/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.item.brew;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.item.Relic;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.item.brew.BaseBrewItem;
import vazkii.botania.common.item.relic.RelicImpl;
import vazkii.botania.xplat.XplatAbstractions;

public class InfiniteWineItem
extends BaseBrewItem {
    public static final int UPDATE_MODULO = 4000;
    private static final int MANA_PER_REGEN = 12000;
    public static final int AMPLIFIER_ADDITION = 1;
    public static final float DURATION_MULTIPLIER = 0.5f;

    public InfiniteWineItem(Item.Properties builder, int swigs, int drinkSpeed, Supplier<Item> baseItem) {
        super(builder, swigs, drinkSpeed, baseItem);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        Relic relic = XplatAbstractions.INSTANCE.findRelic(stack);
        if (relic == null || !relic.isRightPlayer(player) || this.getSwigsLeft(stack) < 1) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        return super.m_7203_(world, player, hand);
    }

    @NotNull
    public ItemStack m_5922_(@NotNull ItemStack stack, Level world, LivingEntity living) {
        if (!world.f_46443_) {
            for (MobEffectInstance effect : this.getBrew(stack).getPotionEffects(stack)) {
                MobEffectInstance newEffect = new MobEffectInstance(effect.m_19544_(), (int)((double)effect.m_19557_() * (1.0 + (double)this.getDurationMultiplier())), effect.m_19564_() + this.getAmplifierAddition(), true, true);
                if (effect.m_19544_().m_8093_()) {
                    effect.m_19544_().m_19461_((Entity)living, (Entity)living, living, newEffect.m_19564_() + this.getAmplifierAddition(), 1.0);
                    continue;
                }
                living.m_7292_(newEffect);
            }
            if (world.f_46441_.m_188499_()) {
                world.m_6263_(null, living.m_20185_(), living.m_20186_(), living.m_20189_(), SoundEvents.f_12321_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            int swigs = this.getSwigsLeft(stack);
            if (living instanceof Player) {
                Player player = (Player)living;
                if (!player.m_150110_().f_35937_) {
                    this.setSwigsLeft(stack, swigs - 1);
                }
            }
        }
        return stack;
    }

    public static Relic makeRelic(ItemStack stack) {
        return new RelicImpl(stack, null);
    }

    public void m_7373_(@NotNull ItemStack stack, Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flags) {
        RelicImpl.addDefaultTooltip((ItemStack)stack, tooltip);
        InfiniteWineItem.addPotionTooltip(this.getBrew(stack).getPotionEffects(stack), tooltip, (float)(1.0 + (double)this.getDurationMultiplier()), this.getAmplifierAddition());
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (!world.f_46443_ && entity instanceof Player) {
            Player player = (Player)entity;
            Relic relic = XplatAbstractions.INSTANCE.findRelic(stack);
            if (relic != null) {
                relic.tickBinding(player);
            }
            if (world.m_46467_() % (long)this.getUpdateModulo() == 0L && this.getSwigsLeft(stack) < this.getSwigs() && ManaItemHandler.instance().requestManaExactForTool(stack, player, this.getManaPerRegen(), true)) {
                this.setSwigsLeft(stack, this.getSwigsLeft(stack) + 1);
            }
        }
    }

    public int getUpdateModulo() {
        return 4000;
    }

    public int getManaPerRegen() {
        return 12000;
    }

    public int getAmplifierAddition() {
        return 1;
    }

    public float getDurationMultiplier() {
        return 0.5f;
    }

    public static void addPotionTooltip(List<MobEffectInstance> list, List<Component> lores, float durationFactor, int amplifierAddition) {
        ArrayList list1 = Lists.newArrayList();
        if (list.isEmpty()) {
            lores.add((Component)Component.m_237115_((String)"effect.none").m_130940_(ChatFormatting.GRAY));
        } else {
            for (MobEffectInstance effectinstance : list) {
                MutableComponent iformattabletextcomponent = Component.m_237115_((String)effectinstance.m_19576_());
                MobEffect effect = effectinstance.m_19544_();
                Map map = effect.m_19485_();
                if (!map.isEmpty()) {
                    for (Map.Entry entry : map.entrySet()) {
                        AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                        AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.m_22214_(), effect.m_7048_(effectinstance.m_19564_() + amplifierAddition, attributemodifier), attributemodifier.m_22217_());
                        list1.add(new Pair((Object)((Attribute)entry.getKey()), (Object)attributemodifier1));
                    }
                }
                if (effectinstance.m_19564_() + amplifierAddition > 0) {
                    iformattabletextcomponent = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{iformattabletextcomponent, Component.m_237115_((String)("potion.potency." + (effectinstance.m_19564_() + amplifierAddition)))});
                }
                if (effectinstance.m_19557_() > 20) {
                    iformattabletextcomponent = Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{iformattabletextcomponent, MobEffectUtil.m_267641_((MobEffectInstance)effectinstance, (float)durationFactor)});
                }
                lores.add((Component)iformattabletextcomponent.m_130940_(effect.m_19483_().m_19497_()));
            }
        }
        if (!list1.isEmpty()) {
            lores.add((Component)Component.m_237119_());
            lores.add((Component)Component.m_237115_((String)"potion.whenDrank").m_130940_(ChatFormatting.DARK_PURPLE));
            for (Pair pair : list1) {
                AttributeModifier attributemodifier2 = (AttributeModifier)pair.getSecond();
                double d0 = attributemodifier2.m_22218_();
                double d1 = attributemodifier2.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier2.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL ? attributemodifier2.m_22218_() : attributemodifier2.m_22218_() * 100.0;
                if (d0 > 0.0) {
                    lores.add((Component)Component.m_237110_((String)("attribute.modifier.plus." + attributemodifier2.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1), Component.m_237115_((String)((Attribute)pair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.BLUE));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                lores.add((Component)Component.m_237110_((String)("attribute.modifier.take." + attributemodifier2.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1 *= -1.0), Component.m_237115_((String)((Attribute)pair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.RED));
            }
        }
    }
}

