/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.item.equipment.armor.pleiades_combat_maid;

import io.github.lounode.eventwrapper.event.entity.living.LivingHurtEventWrapper;
import io.github.lounode.eventwrapper.eventbus.api.EventBusSubscriberWrapper;
import io.github.lounode.eventwrapper.eventbus.api.SubscribeEventWrapper;
import io.github.lounode.extrabotany.common.item.equipment.armor.pleiades_combat_maid.PleiadesCombatMaidArmorItem;
import io.github.lounode.extrabotany.common.item.equipment.bauble.NatureOrbItem;
import io.github.lounode.extrabotany.common.lib.ExtraBotanyTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.mana.ManaDiscountArmor;
import vazkii.botania.api.mana.ManaItemHandler;

public class PleiadesCombatMaidSuitItem
extends PleiadesCombatMaidArmorItem
implements ManaDiscountArmor {
    private static final int COMMON_COST = 75;
    private static final float EMPTY_HAND_BONUS = 10.0f;

    public PleiadesCombatMaidSuitItem(Item.Properties properties) {
        super(ArmorItem.Type.CHESTPLATE, properties);
    }

    public float getDiscount(ItemStack stack, int slot, Player player, @Nullable ItemStack tool) {
        return this.hasArmorSet(player) ? 0.3f : 0.0f;
    }

    @Override
    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, world, entity, slot, selected);
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (player.m_6844_(EquipmentSlot.CHEST) != stack) {
            return;
        }
        if (!this.hasArmorSet(player)) {
            return;
        }
        if (player.f_19797_ % 80 == 0 && ManaItemHandler.instance().requestManaExactForTool(stack, player, 75, true)) {
            player.m_5634_(1.0f);
        }
        if (player.f_19797_ % 40 == 0) {
            NatureOrbItem.clearHarmfulPotion((LivingEntity)player);
        }
        ManaItemHandler.instance().dispatchManaExact(stack, player, 1, true);
    }

    public float getEmptyHandBonus() {
        return 10.0f;
    }

    @EventBusSubscriberWrapper
    public static class EventHandler {
        @SubscribeEventWrapper
        public static void onEntityAttacked(LivingHurtEventWrapper event) {
            Entity attacker = event.getSource().m_7639_();
            LivingEntity target = event.getEntity();
            if (!(attacker instanceof Player)) {
                return;
            }
            Player player = (Player)attacker;
            if (target == attacker) {
                return;
            }
            ItemStack suitStack = player.m_6844_(EquipmentSlot.CHEST);
            Item item = suitStack.m_41720_();
            if (!(item instanceof PleiadesCombatMaidSuitItem)) {
                return;
            }
            PleiadesCombatMaidSuitItem suit = (PleiadesCombatMaidSuitItem)item;
            if (!suit.hasArmorSet(player)) {
                return;
            }
            if (player.m_21205_() == ItemStack.f_41583_ && ManaItemHandler.instance().requestManaExactForTool(suitStack, player, 75, true)) {
                event.setAmount(event.getAmount() + suit.getEmptyHandBonus());
            }
            if (player.m_36325_() && ManaItemHandler.instance().requestManaExactForTool(suitStack, player, 75, true)) {
                player.m_5634_(event.getAmount() / 8.0f);
            }
        }

        @SubscribeEventWrapper
        public static void onPlayerAttacked(LivingHurtEventWrapper event) {
            LivingEntity target = event.getEntity();
            if (!(target instanceof Player)) {
                return;
            }
            Player player = (Player)target;
            ItemStack suitStack = player.m_6844_(EquipmentSlot.CHEST);
            Item item = suitStack.m_41720_();
            if (!(item instanceof PleiadesCombatMaidSuitItem)) {
                return;
            }
            PleiadesCombatMaidSuitItem suit = (PleiadesCombatMaidSuitItem)item;
            if (!suit.hasArmorSet(player)) {
                return;
            }
            if (event.getSource().m_269533_(ExtraBotanyTags.DamageTypes.MAID_PROTECTION)) {
                event.setAmount(0.0f);
                event.setCanceled(true);
            }
        }
    }
}

