/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.item.equipment.armor.pleiades_combat_maid;

import com.google.common.base.Suppliers;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.github.lounode.eventwrapper.event.entity.living.LivingDamageEventWrapper;
import io.github.lounode.eventwrapper.event.entity.living.LivingDeathEventWrapper;
import io.github.lounode.eventwrapper.event.entity.living.MobEffectEventWrapper;
import io.github.lounode.eventwrapper.eventbus.api.EventBusSubscriberWrapper;
import io.github.lounode.eventwrapper.eventbus.api.SubscribeEventWrapper;
import io.github.lounode.extrabotany.common.item.ExtraBotanyItems;
import io.github.lounode.extrabotany.common.item.equipment.armor.pleiades_combat_maid.PleiadesCombatMaidSuitItem;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.brew.BotaniaMobEffects;
import vazkii.botania.common.brew.effect.BloodthirstMobEffect;

public class SanguinePleiadesCombatMaidSuitItem
extends PleiadesCombatMaidSuitItem {
    public static final Supplier<ItemStack[]> ARMOR_SET = Suppliers.memoize(() -> new ItemStack[]{new ItemStack((ItemLike)ExtraBotanyItems.pleiadesCombatMaidHeadgear), new ItemStack((ItemLike)ExtraBotanyItems.sanguinePleiadesCombatMaidSuit), new ItemStack((ItemLike)ExtraBotanyItems.pleiadesCombatMaidSkirt), new ItemStack((ItemLike)ExtraBotanyItems.pleiadesCombatMaidBoots)});
    public static int SANGUINE_KILL_REQUIRE = 50;
    public static final float HEAL_RATE = 0.3f;

    public SanguinePleiadesCombatMaidSuitItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        HashMultimap ret = super.m_7167_(slot);
        if (slot == this.m_266204_().m_266308_()) {
            UUID uuid = new UUID(BuiltInRegistries.f_257033_.m_7981_((Object)this).hashCode() + slot.toString().hashCode(), 0L);
            ret = HashMultimap.create(ret);
            ret.removeAll((Object)Attributes.f_22276_);
            ret.put((Object)Attributes.f_22276_, (Object)new AttributeModifier(uuid, "Combatmaid modifier" + String.valueOf(this.f_265916_), 15.0, AttributeModifier.Operation.ADDITION));
        }
        return ret;
    }

    @Override
    public ItemStack[] getArmorSetStacks() {
        return ARMOR_SET.get();
    }

    public static boolean isSenketsu(ItemStack stack) {
        String name = stack.m_41786_().getString().toLowerCase(Locale.ROOT).trim();
        return "senketsu".equals(name);
    }

    @EventBusSubscriberWrapper
    public static class EventHandler {
        private static final Map<UUID, Integer> bloodthirstKilled = new ConcurrentHashMap<UUID, Integer>();

        @SubscribeEventWrapper
        public static void onAttackLiving(LivingDamageEventWrapper event) {
            Entity attacker = event.getSource().m_7639_();
            if (!(attacker instanceof LivingEntity)) {
                return;
            }
            LivingEntity living = (LivingEntity)attacker;
            if (!living.m_6844_(EquipmentSlot.CHEST).m_150930_(ExtraBotanyItems.sanguinePleiadesCombatMaidSuit)) {
                return;
            }
            living.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 200, 1));
            living.m_5634_(0.3f * event.getAmount());
        }

        @SubscribeEventWrapper
        public static void onEffectAdded(MobEffectEventWrapper.Added event) {
            if (!(event.getEffectInstance().m_19544_() instanceof BloodthirstMobEffect)) {
                return;
            }
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            bloodthirstKilled.put(serverPlayer.m_20148_(), 0);
        }

        @SubscribeEventWrapper
        public static void onKilled(LivingDeathEventWrapper event) {
            Entity entity = event.getSource().m_7639_();
            if (!(entity instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (!serverPlayer.m_21023_(BotaniaMobEffects.bloodthrst)) {
                return;
            }
            bloodthirstKilled.computeIfPresent(serverPlayer.m_20148_(), (uuid, count) -> count + 1);
        }

        @SubscribeEventWrapper
        public static void onEffectRemove(MobEffectEventWrapper.Remove event) {
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                EventHandler.onEffectRemovedOrExpired(serverPlayer, event.getEffectInstance());
            }
        }

        @SubscribeEventWrapper
        public static void onEffectExpired(MobEffectEventWrapper.Expired event) {
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                EventHandler.onEffectRemovedOrExpired(serverPlayer, event.getEffectInstance());
            }
        }

        private static void onEffectRemovedOrExpired(ServerPlayer serverPlayer, @Nullable MobEffectInstance instance) {
            if (instance == null) {
                return;
            }
            if (!(instance.m_19544_() instanceof BloodthirstMobEffect)) {
                return;
            }
            if (!bloodthirstKilled.containsKey(serverPlayer.m_20148_())) {
                return;
            }
            EventHandler.replaceArmor(serverPlayer);
        }

        private static void replaceArmor(ServerPlayer serverPlayer) {
            int killed = bloodthirstKilled.get(serverPlayer.m_20148_());
            bloodthirstKilled.remove(serverPlayer.m_20148_());
            ItemStack origin = serverPlayer.m_6844_(EquipmentSlot.CHEST);
            if (killed >= SANGUINE_KILL_REQUIRE && origin.m_150930_(ExtraBotanyItems.pleiadesCombatMaidSuit)) {
                ItemStack darkened = new ItemStack((ItemLike)ExtraBotanyItems.sanguinePleiadesCombatMaidSuit);
                CompoundTag originTag = origin.m_41783_();
                if (originTag != null) {
                    CompoundTag newTag = originTag.m_6426_();
                    darkened.m_41751_(newTag);
                }
                serverPlayer.m_8061_(EquipmentSlot.CHEST, darkened);
            }
        }
    }
}

