/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.item.equipment.tool.hammer;

import io.github.lounode.extrabotany.common.item.equipment.tool.hammer.ManasteelHammerItem;
import io.github.lounode.extrabotany.common.sounds.ExtraBotanySounds;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import vazkii.botania.api.item.SequentialBreaker;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.equipment.tool.ToolCommons;

public class TerrasteelHammerItem
extends ManasteelHammerItem
implements SequentialBreaker {
    private static final String TAG_ENABLED = "Enabled";
    private static final int MANA_PER_DAMAGE = 100;
    private static final int ACTIVE_COST = 10;
    public static final int RANGE = 2;

    public TerrasteelHammerItem(Tier tier, int attackDamageModifier, float attackSpeedModifier, Item.Properties properties) {
        super(tier, attackDamageModifier, attackSpeedModifier, properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!player.m_36341_()) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        BlockHitResult blockhitresult = TerrasteelHammerItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (blockhitresult.m_6662_() == HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        this.setEnabled(stack, !TerrasteelHammerItem.isEnabled(stack));
        if (!level.f_46443_) {
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), ExtraBotanySounds.HAMMER_USE, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, Player player) {
        BlockHitResult raycast = ToolCommons.raytraceFromEntity((Entity)player, (double)10.0, (boolean)false);
        if (!player.m_9236_().f_46443_ && raycast.m_6662_() == HitResult.Type.BLOCK) {
            Direction face = raycast.m_82434_();
            this.breakOtherBlock(player, stack, pos, pos, face);
        }
        return false;
    }

    public void breakOtherBlock(Player player, ItemStack stack, BlockPos pos, BlockPos originPos, Direction side) {
        if (!TerrasteelHammerItem.isEnabled(stack)) {
            return;
        }
        Predicate<BlockState> canMine = state -> {
            boolean rightToolForDrops = !state.m_60834_() || stack.m_41735_(state);
            boolean rightToolForSpeed = stack.m_41691_(state) > 1.0f || state.m_204336_(BlockTags.f_144283_) || state.m_204336_(BlockTags.f_144281_);
            return rightToolForDrops && rightToolForSpeed;
        };
        Level world = player.m_9236_();
        BlockState targetState = world.m_8055_(pos);
        if (!canMine.test(targetState)) {
            return;
        }
        if (world.m_46859_(pos)) {
            return;
        }
        boolean doX = side.m_122429_() == 0;
        boolean doY = side.m_122430_() == 0;
        boolean doZ = side.m_122431_() == 0;
        int range = this.getRange(player, stack, pos, originPos, side);
        Vec3i beginDiff = new Vec3i(doX ? -range : 0, doY ? -1 : 0, doZ ? -range : 0);
        Vec3i endDiff = new Vec3i(doX ? range : 0, doY ? range * 2 - 1 : 0, doZ ? range : 0);
        ToolCommons.removeBlocksInIteration((Player)player, (ItemStack)stack, (Level)world, (BlockPos)pos, (Vec3i)beginDiff, (Vec3i)endDiff, canMine);
    }

    @Override
    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, world, entity, slot, selected);
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!TerrasteelHammerItem.isEnabled(stack)) {
            return;
        }
        if (player.f_20911_) {
            return;
        }
        if (!ManaItemHandler.instance().requestManaExactForTool(stack, player, this.getActiveCost(), true)) {
            this.setEnabled(stack, false);
        }
    }

    public static boolean isEnabled(ItemStack stack) {
        return ItemNBTHelper.getBoolean((ItemStack)stack, (String)TAG_ENABLED, (boolean)false);
    }

    public void setEnabled(ItemStack stack, boolean enabled) {
        ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_ENABLED, (boolean)enabled);
    }

    @Override
    public int getManaPerDamage() {
        return 100;
    }

    public int getActiveCost() {
        return 10;
    }

    public int getRange(Player player, ItemStack stack, BlockPos pos, BlockPos originPos, Direction side) {
        return 2;
    }
}

