/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.item.lens;

import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.mana.BurstProperties;
import vazkii.botania.api.recipe.ManaInfusionRecipe;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.item.lens.Lens;

public class ManaLens
extends Lens {
    public void apply(ItemStack stack, BurstProperties props) {
        props.maxMana = 1000;
        props.motionModifier *= 0.5f;
        props.manaLossPerTick *= 0.2f;
        props.color = Objects.requireNonNull(ChatFormatting.AQUA.m_126665_());
    }

    public void updateBurst(ManaBurst burst, ItemStack stack) {
        ThrowableProjectile burstEntity = burst.entity();
        if (burstEntity.m_9236_().m_5776_()) {
            return;
        }
        if (burst.isFake()) {
            return;
        }
        Level level = burstEntity.m_9236_();
        List entities = level.m_45976_(ItemEntity.class, this.getAABB(burst));
        for (ItemEntity entity : entities) {
            int manaToConsume;
            BlockState state;
            if (entity.m_32063_()) continue;
            int mana = burst.getMana();
            ItemStack stack1 = entity.m_32055_();
            ManaInfusionRecipe recipe = ManaLens.getRecipe(level, stack1, state = level.m_8055_(entity.m_20183_().m_7495_()));
            if (recipe == null || mana < (manaToConsume = recipe.getManaToConsume())) continue;
            burst.setMana(mana - manaToConsume);
            stack1.m_41774_(1);
            ItemStack output = recipe.m_8043_(level.m_9598_()).m_41777_();
            ItemEntity outputEntity = new ItemEntity(level, entity.m_20185_(), entity.m_20186_() + 0.5, entity.m_20189_() + 0.5, output);
            outputEntity.m_32010_(50);
            level.m_7967_((Entity)outputEntity);
        }
    }

    public AABB getAABB(ManaBurst burst) {
        ThrowableProjectile burstEntity = burst.entity();
        return new AABB(burstEntity.m_20185_(), burstEntity.m_20186_(), burstEntity.m_20189_(), burstEntity.f_19790_, burstEntity.f_19791_, burstEntity.f_19792_).m_82400_(1.0);
    }

    @Nullable
    public static ManaInfusionRecipe getRecipe(Level level, ItemStack stack, BlockState state) {
        List<ManaInfusionRecipe> recipes = BotaniaRecipeTypes.getRecipes((Level)level, (RecipeType)BotaniaRecipeTypes.MANA_INFUSION_TYPE).values().stream().filter(r -> r instanceof ManaInfusionRecipe).toList();
        for (ManaInfusionRecipe recipe : recipes) {
            boolean flag1 = recipe.matches(stack);
            boolean flag2 = true;
            if (recipe.getRecipeCatalyst() != null && !recipe.getRecipeCatalyst().test(state)) {
                flag2 = false;
            }
            if (!flag1 || !flag2) continue;
            return recipe;
        }
        return null;
    }
}

