/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.item.lens;

import io.github.lounode.extrabotany.common.brew.BrewUtil;
import java.util.List;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.mana.BurstProperties;
import vazkii.botania.common.brew.BotaniaBrews;
import vazkii.botania.common.item.lens.Lens;

public class PotionLens
extends Lens {
    public void apply(ItemStack stack, BurstProperties props) {
        props.motionModifier *= 0.9f;
        props.maxMana *= 4;
        props.manaLossPerTick *= 4.0f;
        Brew brew = BrewUtil.getBrew(stack);
        if (brew != BotaniaBrews.fallbackBrew) {
            props.color = brew.getColor(stack);
        }
    }

    public boolean collideBurst(ManaBurst burst, HitResult pos, boolean isManaBlock, boolean shouldKill, ItemStack stack) {
        ThrowableProjectile burstEntity = burst.entity();
        Level level = burstEntity.m_9236_();
        if (level.m_5776_()) {
            return false;
        }
        if (burst.isFake()) {
            return shouldKill;
        }
        Brew brew = BrewUtil.getBrew(stack);
        if (brew == BotaniaBrews.fallbackBrew) {
            return shouldKill;
        }
        List entities = level.m_45976_(LivingEntity.class, this.getAABB(burst));
        for (LivingEntity entity : entities) {
            this.applyBrewForLivingEntity(entity, brew);
        }
        return true;
    }

    public void applyBrewForLivingEntity(LivingEntity entity, Brew brew) {
        List<MobEffectInstance> effectInstances = BrewUtil.getPotionEffects(brew);
        for (MobEffectInstance effect : effectInstances) {
            MobEffectInstance newInstance = new MobEffectInstance(effect.m_19544_(), effect.m_19557_() / 3, effect.m_19564_(), true, true);
            if (effect.m_19544_().m_8093_()) {
                effect.m_19544_().m_19461_(null, null, entity, effect.m_19564_(), 1.0);
                continue;
            }
            entity.m_7292_(newInstance);
        }
    }

    public AABB getAABB(ManaBurst burst) {
        ThrowableProjectile burstEntity = burst.entity();
        return new AABB(burstEntity.m_20185_(), burstEntity.m_20186_(), burstEntity.m_20189_(), burstEntity.f_19790_, burstEntity.f_19791_, burstEntity.f_19792_).m_82400_(1.0);
    }
}

