/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.item.lens;

import java.util.Comparator;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.item.lens.Lens;

public class TraceLens
extends Lens {
    public static final double SEARCH_TARGET_RADIUS = 5.0;
    public static final int INIT_TICKS = 5;

    public void updateBurst(ManaBurst burst, ItemStack stack) {
        ThrowableProjectile burstEntity = burst.entity();
        if (burstEntity.f_19797_ < 5) {
            return;
        }
        this.rotateToEnemy(burst);
    }

    public void rotateToEnemy(ManaBurst burst) {
        ThrowableProjectile burstEntity = burst.entity();
        LivingEntity target = this.findTarget(burst);
        if (target == null) {
            return;
        }
        Vec3 thisVec = VecHelper.fromEntityCenter((Entity)burstEntity);
        Vec3 targetVec = VecHelper.fromEntityCenter((Entity)target);
        Vec3 diffVec = targetVec.m_82546_(thisVec);
        Vec3 motionVec = diffVec.m_82541_().m_82490_(0.6);
        burstEntity.m_20256_(motionVec);
    }

    @Nullable
    public LivingEntity findTarget(ManaBurst burst) {
        ThrowableProjectile burstEntity = burst.entity();
        AABB searchBox = new AABB(burstEntity.m_20185_(), burstEntity.m_20186_(), burstEntity.m_20189_(), burstEntity.f_19790_, burstEntity.f_19791_, burstEntity.f_19792_).m_82400_(5.0);
        return burstEntity.m_9236_().m_45976_(LivingEntity.class, searchBox).stream().filter(this::canTargetEntity).filter(living -> living.f_20916_ == 0).filter(living -> living != burstEntity.m_19749_()).min(Comparator.comparingInt(this::getEntityPriority)).orElse(null);
    }

    public boolean canTargetEntity(LivingEntity entity) {
        return true;
    }

    public int getEntityPriority(LivingEntity entity) {
        if (entity instanceof Mob) {
            return 3;
        }
        if (entity instanceof Player) {
            return 2;
        }
        if (entity instanceof Animal) {
            return 1;
        }
        return 0;
    }
}

