/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.item.lens;

import io.github.lounode.extrabotany.common.ExtraBotanyDamageTypes;
import io.github.lounode.extrabotany.common.item.material.ItemTiers;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.common.entity.ManaBurstEntity;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.item.lens.Lens;

public class Tracking
extends Lens {
    public static final double SEARCH_TARGET_RADIUS = 5.0;
    private static final int MANA_PRE_DAMAGE = 65;

    public void updateBurst(ManaBurst burst, ItemStack stack) {
        block8: {
            Player player;
            Entity thrower;
            ManaBurstEntity burstEntity;
            block7: {
                block6: {
                    burstEntity = (ManaBurstEntity)burst.entity();
                    thrower = burstEntity.m_19749_();
                    if (!(thrower instanceof Player)) break block6;
                    player = (Player)thrower;
                    if (thrower.m_6084_()) break block7;
                }
                burstEntity.m_146870_();
                return;
            }
            this.rotateToEnemy(burstEntity);
            if (burstEntity.m_9236_().m_5776_()) {
                return;
            }
            AABB axis = new AABB(burstEntity.m_20185_(), burstEntity.m_20186_(), burstEntity.m_20189_(), burstEntity.f_19790_, burstEntity.f_19791_, burstEntity.f_19792_).m_82400_(1.0);
            List<LivingEntity> entities = burstEntity.m_9236_().m_45976_(LivingEntity.class, axis).stream().filter(e -> e != thrower).filter(e -> {
                Player other;
                return !(e instanceof Player && !player.m_7099_(other = (Player)e));
            }).filter(e -> e.f_20916_ == 0).toList();
            Iterator<LivingEntity> iterator = entities.iterator();
            if (!iterator.hasNext()) break block8;
            LivingEntity entity = iterator.next();
            int cost = 65;
            int mana = burst.getMana();
            if (mana >= cost) {
                burst.setMana(mana - cost);
                float damage = 5.0f + ItemTiers.EXCALIBUR.m_6631_();
                DamageSource source = ExtraBotanyDamageTypes.Sources.excaliburDamage(player.m_9236_().m_9598_(), (Entity)player);
                entity.m_6469_(source, damage);
                burstEntity.m_146870_();
            }
        }
    }

    private void rotateToEnemy(ManaBurstEntity burstEntity) {
        AABB searchBox = new AABB(burstEntity.m_20185_(), burstEntity.m_20186_(), burstEntity.m_20189_(), burstEntity.f_19790_, burstEntity.f_19791_, burstEntity.f_19792_).m_82400_(5.0);
        burstEntity.m_9236_().m_45976_(LivingEntity.class, searchBox).stream().filter(this::canTargetEntity).filter(living -> living.f_20916_ == 0).filter(living -> living != burstEntity.m_19749_()).sorted(Comparator.comparingInt(this::getEntityPriority)).findFirst().ifPresent(target -> {
            Vec3 thisVec = VecHelper.fromEntityCenter((Entity)burstEntity);
            Vec3 targetVec = VecHelper.fromEntityCenter((Entity)target);
            Vec3 diffVec = targetVec.m_82546_(thisVec);
            Vec3 motionVec = diffVec.m_82541_().m_82490_(0.6);
            burstEntity.m_20256_(motionVec);
        });
    }

    public boolean canTargetEntity(LivingEntity entity) {
        return entity instanceof Mob || entity instanceof Player;
    }

    public int getEntityPriority(LivingEntity entity) {
        if (entity instanceof Mob) {
            return 3;
        }
        if (entity instanceof Player) {
            return 2;
        }
        if (entity instanceof Animal) {
            return 1;
        }
        return 0;
    }
}

