/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.item.relic;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.github.lounode.extrabotany.common.item.equipment.shield.ManasteelShieldItem;
import io.github.lounode.extrabotany.common.item.material.ItemTiers;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.item.Relic;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.handler.PixieHandler;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.relic.RelicImpl;
import vazkii.botania.xplat.XplatAbstractions;

public class AchillesShieldItem
extends ManasteelShieldItem {
    public static final String TAG_RELEASED = "released";
    private static final float RELEASE_ABSORPTION_REQUIRE = 10.0f;
    private static final float MAX_ABSORPTION = 20.0f;

    public AchillesShieldItem(Item.Properties properties) {
        super(properties.m_41499_(ItemTiers.ACHILLES_SHIELD.m_6609_()), ItemTiers.ACHILLES_SHIELD);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!AchillesShieldItem.isReleased(stack)) {
            if (hand == InteractionHand.MAIN_HAND && player.m_36341_() && player.m_6103_() >= 10.0f) {
                AchillesShieldItem.setReleased(stack, true);
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            return super.m_7203_(level, player, hand);
        }
        if (hand == InteractionHand.MAIN_HAND && player.m_36341_()) {
            AchillesShieldItem.setReleased(stack, false);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    @Override
    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, world, entity, slot, selected);
        if (!world.f_46443_ && entity instanceof Player) {
            Player player = (Player)entity;
            Relic relic = XplatAbstractions.INSTANCE.findRelic(stack);
            if (relic != null) {
                relic.tickBinding(player);
            }
            if (AchillesShieldItem.isReleased(stack) && player.f_19797_ % 10 == 0) {
                if (player.m_6103_() <= 0.0f) {
                    AchillesShieldItem.setReleased(stack, false);
                }
                player.m_7911_(player.m_6103_() - 1.0f);
            }
        }
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int remainingUseDuration) {
        super.m_5929_(level, entity, stack, remainingUseDuration);
        if (AchillesShieldItem.isReleased(stack)) {
            entity.m_5810_();
        }
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (AchillesShieldItem.isReleased(stack)) {
            BotaniaItems.thunderSword.m_7579_(stack, target, attacker);
        } else {
            attacker.m_7911_(Math.min(20.0f, attacker.m_6103_() + 2.0f));
        }
        return super.m_7579_(stack, target, attacker);
    }

    @Override
    public void onShieldBlock(ItemStack stack, LivingEntity blocker, DamageSource source, float damage) {
        Player player;
        super.onShieldBlock(stack, blocker, source, damage);
        Entity attacker = source.m_7639_();
        if (attacker == null) {
            return;
        }
        if (blocker instanceof Player && ManaItemHandler.INSTANCE.requestManaExactForTool(stack, player = (Player)blocker, 500, true)) {
            attacker.m_6469_(player.m_269291_().m_269374_((Entity)player), damage);
        }
    }

    public static boolean isReleased(ItemStack stack) {
        return ItemNBTHelper.getBoolean((ItemStack)stack, (String)TAG_RELEASED, (boolean)false);
    }

    public static void setReleased(ItemStack stack, boolean mode) {
        ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_RELEASED, (boolean)mode);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        Multimap ret = super.m_7167_(slot);
        ret = HashMultimap.create((Multimap)ret);
        if (slot == EquipmentSlot.MAINHAND) {
            UUID uuid = new UUID((this.m_5524_() + String.valueOf(slot)).hashCode(), 0L);
            if (AchillesShieldItem.isReleased(stack)) {
                ret.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(uuid, "Tool modifier", (double)0.4f, AttributeModifier.Operation.MULTIPLY_BASE));
            }
            ret.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(uuid, "Tool modifier", -2.6, AttributeModifier.Operation.ADDITION));
            ret.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(uuid, "Weapon modifier", AchillesShieldItem.isReleased(stack) ? 15.0 : 6.0, AttributeModifier.Operation.ADDITION));
        }
        if (slot == EquipmentSlot.OFFHAND) {
            ret.put((Object)PixieHandler.PIXIE_SPAWN_CHANCE, (Object)PixieHandler.makeModifier((EquipmentSlot)slot, (String)"Shield modifier", (double)0.5));
        }
        return ret;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(ItemStack stack, EquipmentSlot slot) {
        return this.getAttributeModifiers(slot, stack);
    }

    public static Relic makeRelic(ItemStack stack) {
        return new RelicImpl(stack, null);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flags) {
        super.m_7373_(stack, world, tooltip, flags);
        RelicImpl.addDefaultTooltip((ItemStack)stack, tooltip);
    }
}

