/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.item.relic;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.lounode.eventwrapper.event.entity.player.ItemCooldownFinishEventWrapper;
import io.github.lounode.eventwrapper.eventbus.api.EventBusSubscriberWrapper;
import io.github.lounode.eventwrapper.eventbus.api.SubscribeEventWrapper;
import io.github.lounode.extrabotany.api.item.IShadowium;
import io.github.lounode.extrabotany.common.brew.ExtraBotanyMobEffects;
import io.github.lounode.extrabotany.common.lib.ResourceLocationHelper;
import io.github.lounode.extrabotany.common.sounds.ExtraBotanySounds;
import io.github.lounode.extrabotany.common.util.SoundEventUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import vazkii.botania.api.item.Relic;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.item.relic.RelicImpl;
import vazkii.botania.common.item.relic.RelicItem;
import vazkii.botania.xplat.XplatAbstractions;

@EventBusSubscriberWrapper
public class CameraItem
extends RelicItem
implements IShadowium {
    private static final int MANA_PER_USE = 1500;
    private static final int RANGE = 20;
    private static final int ADVANCEMENT_REQUIRE = 10;

    public CameraItem(Item.Properties props) {
        super(props);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        Relic relic = XplatAbstractions.INSTANCE.findRelic(stack);
        if (relic == null || !relic.isRightPlayer(player) || !ManaItemHandler.instance().requestManaExactForTool(stack, player, 1500, false)) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        player.m_6330_(ExtraBotanySounds.CAMERA_FOCUS, SoundSource.PLAYERS, 0.3f, SoundEventUtil.randomPitch(world));
        return ItemUtils.m_150959_((Level)world, (Player)player, (InteractionHand)hand);
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity entity, int timeLeft) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (CameraItem.executeCapture(world, player, player.m_7655_()).m_19089_() == InteractionResult.SUCCESS) {
            player.m_36335_().m_41524_((Item)this, 160);
        }
    }

    public int m_8105_(ItemStack stack) {
        return 1200;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.SPYGLASS;
    }

    public static InteractionResultHolder<ItemStack> executeCapture(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        Relic relic = XplatAbstractions.INSTANCE.findRelic(stack);
        if (relic != null && (player.m_7500_() || relic.isRightPlayer(player) && ManaItemHandler.instance().requestManaExactForTool(stack, player, 1500, true))) {
            List<LivingEntity> livingEntities = world.m_45976_(LivingEntity.class, CameraItem.getFreezeBounds(player)).stream().filter(entity -> !entity.equals((Object)player)).filter(entity -> entity.m_5647_() == null || !entity.m_5647_().m_83536_(player.m_5647_())).toList();
            for (LivingEntity livingEntity : livingEntities) {
                livingEntity.m_7292_(new MobEffectInstance(ExtraBotanyMobEffects.LINK, 200));
            }
            if (!world.m_5776_() && livingEntities.size() >= 10) {
                PlayerHelper.grantCriterion((ServerPlayer)((ServerPlayer)player), (ResourceLocation)ResourceLocationHelper.prefix("main/i_see_everything"), (String)"code_triggered");
            }
            List<Projectile> projectiles = world.m_45976_(Projectile.class, CameraItem.getFreezeBounds(player)).stream().filter(entity -> entity.m_19749_() != player).filter(entity -> entity.m_5647_() == null || !entity.m_5647_().m_83536_(player.m_5647_())).toList();
            for (Projectile projectile : projectiles) {
                projectile.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            world.m_247517_(null, player.m_20097_(), ExtraBotanySounds.CAMERA_USE, SoundSource.PLAYERS);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        this.shadowiumTick(stack, world, entity, slot, selected);
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        super.m_6883_(stack, world, entity, slot, selected);
        ItemStack usingItem = player.m_21211_();
        if (usingItem.m_41619_() || !(usingItem.m_41720_() instanceof CameraItem)) {
            return;
        }
        AABB bounds = CameraItem.getFreezeBounds(player);
        List<LivingEntity> targets = player.m_9236_().m_45976_(LivingEntity.class, bounds).stream().filter(e -> !e.equals((Object)player)).filter(e -> e.m_5647_() == null || !e.m_5647_().m_83536_(player.m_5647_())).toList();
        for (LivingEntity target : targets) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 2, 0, false, true, true));
        }
    }

    public static void renderAABBBorder(Level level, AABB bounds) {
        int particleDensity = 10;
        float red = 1.0f;
        float green = 0.0f;
        float blue = 0.0f;
        float scale = 1.0f;
        double xStep = (bounds.f_82291_ - bounds.f_82288_) / (double)particleDensity;
        double yStep = (bounds.f_82292_ - bounds.f_82289_) / (double)particleDensity;
        double zStep = (bounds.f_82293_ - bounds.f_82290_) / (double)particleDensity;
        for (int i = 0; i <= particleDensity; ++i) {
            CameraItem.spawnParticle(level, bounds.f_82288_ + xStep * (double)i, bounds.f_82289_, bounds.f_82290_, red, green, blue, scale);
            CameraItem.spawnParticle(level, bounds.f_82288_ + xStep * (double)i, bounds.f_82289_, bounds.f_82293_, red, green, blue, scale);
            CameraItem.spawnParticle(level, bounds.f_82288_, bounds.f_82289_, bounds.f_82290_ + zStep * (double)i, red, green, blue, scale);
            CameraItem.spawnParticle(level, bounds.f_82291_, bounds.f_82289_, bounds.f_82290_ + zStep * (double)i, red, green, blue, scale);
            CameraItem.spawnParticle(level, bounds.f_82288_ + xStep * (double)i, bounds.f_82292_, bounds.f_82290_, red, green, blue, scale);
            CameraItem.spawnParticle(level, bounds.f_82288_ + xStep * (double)i, bounds.f_82292_, bounds.f_82293_, red, green, blue, scale);
            CameraItem.spawnParticle(level, bounds.f_82288_, bounds.f_82292_, bounds.f_82290_ + zStep * (double)i, red, green, blue, scale);
            CameraItem.spawnParticle(level, bounds.f_82291_, bounds.f_82292_, bounds.f_82290_ + zStep * (double)i, red, green, blue, scale);
            CameraItem.spawnParticle(level, bounds.f_82288_, bounds.f_82289_ + yStep * (double)i, bounds.f_82290_, red, green, blue, scale);
            CameraItem.spawnParticle(level, bounds.f_82291_, bounds.f_82289_ + yStep * (double)i, bounds.f_82290_, red, green, blue, scale);
            CameraItem.spawnParticle(level, bounds.f_82288_, bounds.f_82289_ + yStep * (double)i, bounds.f_82293_, red, green, blue, scale);
            CameraItem.spawnParticle(level, bounds.f_82291_, bounds.f_82289_ + yStep * (double)i, bounds.f_82293_, red, green, blue, scale);
        }
    }

    private static void spawnParticle(Level level, double x, double y, double z, float r, float g, float b, float scale) {
        if (level.f_46443_) {
            level.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(r, g, b), scale), x, y, z, 0.0, 0.0, 0.0);
        }
    }

    @SubscribeEventWrapper
    public static void onItemCooldownFinish(ItemCooldownFinishEventWrapper event) {
        if (!(event.getItem() instanceof CameraItem)) {
            return;
        }
        Player player = event.getEntity();
        if (!player.m_9236_().m_5776_()) {
            return;
        }
        player.m_6330_(ExtraBotanySounds.CAMERA_CHARGE, SoundSource.PLAYERS, 0.3f, SoundEventUtil.randomPitch(player.m_9236_()));
    }

    public int getManaPerUse() {
        return 1500;
    }

    public int getRange() {
        return 20;
    }

    public static AABB getFreezeBounds(Player player) {
        Vec3 lookVec = player.m_20154_();
        Vec3 center = player.m_146892_().m_82549_(lookVec.m_82490_(15.0));
        double halfRange = 10.0;
        return new AABB(center.f_82479_ - halfRange, center.f_82480_ - halfRange, center.f_82481_ - halfRange, center.f_82479_ + halfRange, center.f_82480_ + halfRange, center.f_82481_ + halfRange);
    }

    public static Relic makeRelic(ItemStack stack) {
        return new RelicImpl(stack, null);
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flags) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.extrabotany.camera").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
        tooltip.add((Component)Component.m_237113_((String)""));
        super.m_7373_(stack, world, tooltip, flags);
    }

    public static class Hud {
        public static final ResourceLocation CAMERA_UI_LOCATION = ResourceLocationHelper.prefix("textures/gui/spyglass_scope.png");

        public static void renderSpyglassOverlay(GuiGraphics pGuiGraphics, float pScopeScale) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            float f = Math.min(pGuiGraphics.m_280182_(), pGuiGraphics.m_280206_());
            float f1 = Math.min((float)pGuiGraphics.m_280182_() / f, (float)pGuiGraphics.m_280206_() / f) * pScopeScale;
            int i = Mth.m_14143_((float)(f * f1));
            int j = Mth.m_14143_((float)(f * f1));
            int k = (pGuiGraphics.m_280182_() - i) / 2;
            int l = (pGuiGraphics.m_280206_() - j) / 2;
            int i1 = k + i;
            int j1 = l + j;
            pGuiGraphics.m_280398_(CAMERA_UI_LOCATION, k, l, -90, 0.0f, 0.0f, i, j, i, j);
            RenderSystem.disableBlend();
        }
    }
}

