/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.item.relic.void_archives.variants;

import io.github.lounode.extrabotany.api.item.VoidArchivesVariant;
import io.github.lounode.extrabotany.common.item.relic.CameraItem;
import io.github.lounode.extrabotany.common.item.relic.void_archives.VoidArchivesItem;
import io.github.lounode.extrabotany.common.sounds.ExtraBotanySounds;
import io.github.lounode.extrabotany.common.util.SoundEventUtil;
import java.util.List;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class Camera
implements VoidArchivesVariant {
    public static Camera INSTANCE = new Camera();
    private static final String ID = "camera";

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        player.m_6330_(ExtraBotanySounds.CAMERA_FOCUS, SoundSource.PLAYERS, 0.3f, SoundEventUtil.randomPitch(level));
        return ItemUtils.m_150959_((Level)level, (Player)player, (InteractionHand)hand);
    }

    @Override
    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        ItemStack usingItem = player.m_21211_();
        if (usingItem.m_41619_() || !(usingItem.m_41720_() instanceof VoidArchivesItem)) {
            return;
        }
        AABB bounds = CameraItem.getFreezeBounds(player);
        List<LivingEntity> targets = player.m_9236_().m_45976_(LivingEntity.class, bounds).stream().filter(e -> !e.equals((Object)player)).filter(e -> e.m_5647_() == null || !e.m_5647_().m_83536_(player.m_5647_())).toList();
        for (LivingEntity target : targets) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 2, 0, false, true, true));
        }
    }

    @Override
    public void releaseUsing(ItemStack stack, Level world, LivingEntity entity, int timeLeft) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        CameraItem.executeCapture(world, player, player.m_7655_());
    }

    @Override
    public int getUseDuration(ItemStack stack) {
        return 1200;
    }

    @Override
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.SPYGLASS;
    }
}

