/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.item.relic.void_archives.variants;

import io.github.lounode.extrabotany.api.item.VoidArchivesVariant;
import io.github.lounode.extrabotany.common.entity.MagicArrowEntity;
import io.github.lounode.extrabotany.common.item.ExtraBotanyItems;
import io.github.lounode.extrabotany.common.sounds.ExtraBotanySounds;
import net.minecraft.nbt.ListTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import vazkii.botania.api.item.Relic;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.entity.ManaBurstEntity;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.xplat.XplatAbstractions;

public class Failnaught
implements VoidArchivesVariant {
    public static Failnaught INSTANCE = new Failnaught();
    private static final String ID = "failnaught";
    public static final float[] TIER_PROCESS = new float[]{0.0f, 0.0f, 0.35f, 0.7f, 0.9f};
    public static final int[] MANA_PER_USE_MAX = new int[]{0, 350, 500, 650, 800};
    private static final float DEFAULT_CHARGE_SPEED = 0.25f;
    private static final float QUICK_CHARGE_BONUS_PER_LEVEL = 0.1f;
    public static final float MINIMUM_SHOOT_PROCESS = 0.1f;

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        int multiShoutLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)itemstack);
        float chargeProgress = this.getChargeProcess(itemstack, (LivingEntity)player);
        boolean flag = false;
        Relic relic = XplatAbstractions.INSTANCE.findRelic(itemstack);
        if (relic != null && relic.isRightPlayer(player) && ManaItemHandler.instance().requestManaExactForTool(itemstack, player, this.getManaForUse(chargeProgress) * (multiShoutLevel > 1 ? 3 : 1), false)) {
            flag = true;
        }
        if (!player.m_150110_().f_35937_ && !flag) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    @Override
    public void releaseUsing(ItemStack stack, Level level, LivingEntity livingEntity, int timeCharged) {
        if (level.m_5776_()) {
            return;
        }
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            float chargeProgress = this.getChargeProcess(stack, (LivingEntity)player);
            int quickChargeLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)stack);
            if (quickChargeLevel > 0) {
                ManaItemHandler.instance().requestManaExactForTool(stack, player, 100 * quickChargeLevel, true);
            }
            if (chargeProgress < 0.1f) {
                return;
            }
            int multiShoutLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)stack);
            Relic relic = XplatAbstractions.INSTANCE.findRelic(stack);
            if (relic != null && relic.isRightPlayer(player) && (player.m_150110_().f_35937_ || ManaItemHandler.instance().requestManaExactForTool(stack, player, this.getManaForUse(chargeProgress) * (multiShoutLevel > 1 ? 3 : 1), true))) {
                int manaInBurst = this.getManaForUse(chargeProgress) * (multiShoutLevel > 1 ? 3 : 1);
                float spreadAngle = 10.0f;
                for (int i = 0; i < (multiShoutLevel > 0 ? 3 : 1); ++i) {
                    ManaBurstEntity burst = this.getBurst(player, stack, manaInBurst, this.getTier(chargeProgress));
                    if (multiShoutLevel > 0 && i > 0) {
                        float angle = (i == 1 ? -spreadAngle : spreadAngle) * ((float)Math.PI / 180);
                        burst.m_20256_(burst.m_20184_().m_82524_(angle));
                    }
                    player.m_9236_().m_7967_((Entity)burst);
                }
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), ExtraBotanySounds.FAILNAUGHT_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    public ManaBurstEntity getBurst(Player player, ItemStack stack, int mana, int tier) {
        MagicArrowEntity burst = new MagicArrowEntity(player);
        float motionModifier = 7.0f;
        burst.setColor(0x20FF20);
        burst.setMana(mana);
        burst.setStartingMana(mana);
        burst.setManaLossPerTick((float)MANA_PER_USE_MAX[tier] / 87.5f);
        burst.setGravity(0.0f);
        burst.m_20256_(burst.m_20184_().m_82490_((double)motionModifier));
        ItemStack lens = new ItemStack((ItemLike)ExtraBotanyItems.failnaught);
        ListTag enchants = ItemNBTHelper.getList((ItemStack)stack, (String)"Enchantments", (int)10, (boolean)true);
        if (enchants != null) {
            ItemNBTHelper.setList((ItemStack)lens, (String)"Enchantments", (ListTag)enchants.m_6426_());
        }
        burst.setSourceLens(lens);
        float chargeProcess = this.getChargeProcess(stack, (LivingEntity)player);
        float tierProcess = this.getProcessInTier(chargeProcess);
        float baseDamage = 10.0f;
        int powerLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)stack);
        if (powerLevel > 0 && ManaItemHandler.instance().requestManaExactForTool(stack, player, 50 * powerLevel, true)) {
            baseDamage = baseDamage + 0.5f + 0.5f * (float)powerLevel;
        }
        float damage = baseDamage * ((float)tier * tierProcess);
        burst.setDamage(damage);
        return burst;
    }

    public float getChargeProcess(ItemStack stack, LivingEntity entity) {
        return Mth.m_14036_((float)((float)(this.getUseDuration(stack) - entity.m_21212_()) * this.chargeVelocityMultiplier(stack, entity) / 20.0f), (float)0.0f, (float)1.0f);
    }

    public int getTier(float chargeProcess) {
        if ((chargeProcess = Mth.m_14036_((float)chargeProcess, (float)0.0f, (float)1.0f)) < TIER_PROCESS[2]) {
            return 1;
        }
        if (chargeProcess < TIER_PROCESS[3]) {
            return 2;
        }
        if (chargeProcess < TIER_PROCESS[4]) {
            return 3;
        }
        return 4;
    }

    public float getProcessInTier(float chargeProcess) {
        return switch (this.getTier(chargeProcess)) {
            case 1 -> chargeProcess / TIER_PROCESS[2];
            case 2 -> (chargeProcess - TIER_PROCESS[2]) / (TIER_PROCESS[3] - TIER_PROCESS[2]);
            case 3 -> (chargeProcess - TIER_PROCESS[3]) / (TIER_PROCESS[4] - TIER_PROCESS[3]);
            case 4 -> (chargeProcess - TIER_PROCESS[4]) / (1.0f - TIER_PROCESS[4]);
            default -> 0.0f;
        };
    }

    public int getManaForUse(float chargeProcess) {
        chargeProcess = Mth.m_14036_((float)chargeProcess, (float)0.0f, (float)1.0f);
        int tier = this.getTier(chargeProcess);
        float tierProcess = this.getProcessInTier(chargeProcess);
        return switch (tier) {
            case 1 -> (int)((float)MANA_PER_USE_MAX[1] * tierProcess);
            case 2 -> (int)((float)MANA_PER_USE_MAX[1] + (float)(MANA_PER_USE_MAX[2] - MANA_PER_USE_MAX[1]) * tierProcess);
            case 3 -> (int)((float)MANA_PER_USE_MAX[2] + (float)(MANA_PER_USE_MAX[3] - MANA_PER_USE_MAX[2]) * tierProcess);
            case 4 -> (int)((float)MANA_PER_USE_MAX[3] + (float)(MANA_PER_USE_MAX[4] - MANA_PER_USE_MAX[3]) * tierProcess);
            default -> 0;
        };
    }

    public float chargeVelocityMultiplier(ItemStack itemStack, LivingEntity livingEntity) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            int quickChargeLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)itemStack);
            if (ManaItemHandler.instance().requestManaExactForTool(itemStack, player, 100 * quickChargeLevel, false)) {
                return 0.25f + 0.1f * (float)quickChargeLevel;
            }
        }
        return 0.25f;
    }

    @Override
    public int getUseDuration(ItemStack stack) {
        return 72000;
    }

    @Override
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }
}

