/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.item.relic.void_archives.variants;

import io.github.lounode.extrabotany.api.item.VoidArchivesVariant;
import io.github.lounode.extrabotany.common.item.brew.InfiniteWineItem;
import io.github.lounode.extrabotany.common.lib.ResourceLocationHelper;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.brew.BrewItem;
import vazkii.botania.api.item.Relic;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.xplat.XplatAbstractions;

public class InfiniteWine
implements VoidArchivesVariant,
BrewItem {
    public static InfiniteWine INSTANCE = new InfiniteWine();
    private static final String ID = "infinite_wine";
    private static final String TAG_BREW_KEY = "brewKey";
    private static final ResourceLocation DEFAULT_BREW = ResourceLocationHelper.prefix("all_in_one");
    private static final int MANA_PER_USE = 20000;

    @Override
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        Relic relic = XplatAbstractions.INSTANCE.findRelic(stack);
        if (relic == null || !relic.isRightPlayer(player)) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        return ItemUtils.m_150959_((Level)level, (Player)player, (InteractionHand)hand);
    }

    @Override
    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity living) {
        if (!level.m_5776_()) {
            if (living instanceof Player) {
                Player player = (Player)living;
                ManaItemHandler.instance().requestManaExactForTool(stack, player, InfiniteWine.getManaPerUse(), true);
            }
            for (MobEffectInstance effect : this.getBrew(stack).getPotionEffects(stack)) {
                MobEffectInstance newEffect = new MobEffectInstance(effect.m_19544_(), (int)((double)effect.m_19557_() * (1.0 + (double)this.getDurationMultiplier())), effect.m_19564_() + this.getAmplifierAddition(), true, true);
                if (effect.m_19544_().m_8093_()) {
                    effect.m_19544_().m_19461_((Entity)living, (Entity)living, living, newEffect.m_19564_() + this.getAmplifierAddition(), 1.0);
                    continue;
                }
                living.m_7292_(newEffect);
            }
            if (level.f_46441_.m_188499_()) {
                level.m_6263_(null, living.m_20185_(), living.m_20186_(), living.m_20189_(), SoundEvents.f_12321_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
        return stack;
    }

    @Override
    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        tooltipComponents.add((Component)Component.m_237119_());
        InfiniteWineItem.addPotionTooltip(this.getBrew(stack).getPotionEffects(stack), tooltipComponents, (float)(1.0 + (double)this.getDurationMultiplier()), this.getAmplifierAddition());
    }

    @Override
    public void onActive(ItemStack stack) {
        if (ItemNBTHelper.getString((ItemStack)stack, (String)TAG_BREW_KEY, (String)"").isEmpty()) {
            ItemNBTHelper.setString((ItemStack)stack, (String)TAG_BREW_KEY, (String)InfiniteWine.getDefaultBrew().toString());
        }
    }

    @Override
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    @Override
    public int getUseDuration(ItemStack stack) {
        return 16;
    }

    @Override
    public String getId() {
        return ID;
    }

    public static int getManaPerUse() {
        return 20000;
    }

    public static ResourceLocation getDefaultBrew() {
        return DEFAULT_BREW;
    }

    public Brew getBrew(ItemStack itemStack) {
        String key = ItemNBTHelper.getString((ItemStack)itemStack, (String)TAG_BREW_KEY, (String)"");
        return (Brew)BotaniaAPI.instance().getBrewRegistry().m_7745_(ResourceLocation.m_135820_((String)key));
    }

    public int getAmplifierAddition() {
        return 1;
    }

    public float getDurationMultiplier() {
        return 0.5f;
    }
}

