/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.telemetry;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import io.github.lounode.extrabotany.common.telemetry.TelemetryProperty;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public class TelemetryPropertyMap {
    final Map<TelemetryProperty<?>, Object> entries;

    TelemetryPropertyMap(Map<TelemetryProperty<?>, Object> entries) {
        this.entries = entries;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Codec<TelemetryPropertyMap> createCodec(final List<TelemetryProperty<?>> properties) {
        return new MapCodec<TelemetryPropertyMap>(){

            public <T> RecordBuilder<T> encode(TelemetryPropertyMap map, DynamicOps<T> ops, RecordBuilder<T> builder) {
                RecordBuilder<T> recordbuilder = builder;
                for (TelemetryProperty telemetryproperty : properties) {
                    recordbuilder = this.encodeProperty(map, recordbuilder, telemetryproperty);
                }
                return recordbuilder;
            }

            private <T, V> RecordBuilder<T> encodeProperty(TelemetryPropertyMap map, RecordBuilder<T> builder, TelemetryProperty<V> key) {
                V v = map.get(key);
                return v != null ? builder.add(key.id(), v, key.codec()) : builder;
            }

            public <T> DataResult<TelemetryPropertyMap> decode(DynamicOps<T> ops, MapLike<T> p_262176_) {
                DataResult<Builder> dataresult = DataResult.success((Object)new Builder());
                for (TelemetryProperty telemetryproperty : properties) {
                    dataresult = this.decodeProperty(dataresult, ops, p_262176_, telemetryproperty);
                }
                return dataresult.map(Builder::build);
            }

            private <T, V> DataResult<Builder> decodeProperty(DataResult<Builder> p_261892_, DynamicOps<T> p_261859_, MapLike<T> p_261668_, TelemetryProperty<V> p_261627_) {
                Object t = p_261668_.get(p_261627_.id());
                if (t != null) {
                    DataResult dataresult = p_261627_.codec().parse(p_261859_, t);
                    return p_261892_.apply2stable((p_262028_, p_261796_) -> p_262028_.put(p_261627_, p_261796_), dataresult);
                }
                return p_261892_;
            }

            public <T> Stream<T> keys(DynamicOps<T> p_261746_) {
                return properties.stream().map(TelemetryProperty::id).map(arg_0 -> p_261746_.createString(arg_0));
            }
        }.codec();
    }

    @Nullable
    public <T> T get(TelemetryProperty<T> key) {
        return (T)this.entries.get(key);
    }

    public String toString() {
        return this.entries.toString();
    }

    public Set<TelemetryProperty<?>> propertySet() {
        return this.entries.keySet();
    }

    public JsonObject toJson() {
        Codec<TelemetryPropertyMap> codec = TelemetryPropertyMap.createCodec(this.propertySet().stream().toList());
        return ((JsonElement)codec.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().orElseThrow()).getAsJsonObject();
    }

    public static class Builder {
        private final Map<TelemetryProperty<?>, Object> entries = new Reference2ObjectOpenHashMap();

        Builder() {
        }

        public <T> Builder put(TelemetryProperty<T> key, T value) {
            this.entries.put(key, value);
            return this;
        }

        public <T> Builder putIfNotNull(TelemetryProperty<T> key, @Nullable T value) {
            if (value != null) {
                this.entries.put(key, value);
            }
            return this;
        }

        public Builder putAll(TelemetryPropertyMap propertyMap) {
            this.entries.putAll(propertyMap.entries);
            return this;
        }

        public TelemetryPropertyMap build() {
            return new TelemetryPropertyMap(this.entries);
        }
    }
}

