/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.util;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.client.book.BookContentLoader;
import vazkii.patchouli.client.book.BookContentResourceDirectLoader;
import vazkii.patchouli.client.book.ClientBookRegistry;
import vazkii.patchouli.client.book.template.BookTemplate;
import vazkii.patchouli.common.book.Book;

public class PatchouliUtil {
    public static PatchouliUtil INSTANCE;
    private final Map<ResourceLocation, Supplier<BookTemplate>> templatesPool = new HashMap<ResourceLocation, Supplier<BookTemplate>>();

    private PatchouliUtil() {
    }

    public static void onPatchouliReload(Map<ResourceLocation, Book> books) {
        if (INSTANCE == null) {
            INSTANCE = new PatchouliUtil();
        }
        PatchouliUtil.INSTANCE.templatesPool.clear();
        for (Book book : books.values()) {
            INSTANCE.load(book, "templates", PatchouliUtil::loadTemplate, PatchouliUtil.INSTANCE.templatesPool);
        }
    }

    @Nullable
    public Supplier<BookTemplate> getTemplate(ResourceLocation id) {
        return this.templatesPool.get(id);
    }

    private static Supplier<BookTemplate> loadTemplate(Book book, BookContentLoader loader, ResourceLocation key, ResourceLocation res) {
        JsonElement json = PatchouliUtil.loadLocalizedJson(book, loader, res).json();
        Supplier<BookTemplate> supplier = () -> (BookTemplate)ClientBookRegistry.INSTANCE.gson.fromJson(json, BookTemplate.class);
        BookTemplate template = supplier.get();
        if (template == null) {
            throw new IllegalArgumentException(String.valueOf(res) + " could not be instantiated by the supplier.");
        }
        return supplier;
    }

    private static BookContentLoader.LoadResult loadLocalizedJson(Book book, BookContentLoader loader, ResourceLocation file) {
        ResourceLocation localizedFile = ResourceLocation.m_214293_((String)file.m_135827_(), (String)file.m_135815_().replaceAll("en_us", ClientBookRegistry.INSTANCE.currentLang));
        BookContentLoader.LoadResult input = loader.loadJson(book, localizedFile);
        if (input == null && (input = loader.loadJson(book, file)) == null) {
            throw new IllegalArgumentException(String.valueOf(file) + " does not exist.");
        }
        return input;
    }

    private <T> void load(Book book, String thing, LoadFunc<T> loader, Map<ResourceLocation, T> builder) {
        BookContentResourceDirectLoader contentLoader = BookContentResourceDirectLoader.INSTANCE;
        ArrayList foundIds = new ArrayList();
        contentLoader.findFiles(book, thing, foundIds);
        for (ResourceLocation id : foundIds) {
            String filePath = String.format("%s/%s/%s/%s/%s.json", "patchouli_books", book.id.m_135815_(), "en_us", thing, id.m_135815_());
            T value = loader.load(book, (BookContentLoader)contentLoader, id, ResourceLocation.m_214293_((String)id.m_135827_(), (String)filePath));
            if (value == null) continue;
            builder.put(id, value);
        }
    }

    private static interface LoadFunc<T> {
        @Nullable
        public T load(Book var1, BookContentLoader var2, ResourceLocation var3, ResourceLocation var4);
    }
}

