/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.data.loot;

import com.google.gson.JsonElement;
import io.github.lounode.extrabotany.common.block.flower.ExtrabotanyFlowerBlocks;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.storage.loot.Deserializers;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.jetbrains.annotations.NotNull;

public class BlockLootProvider
implements DataProvider {
    private static final LootItemCondition.Builder SILK_TOUCH = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))));
    private static final Function<Block, LootTable.Builder> SKIP = b -> {
        throw new RuntimeException("shouldn't be executed");
    };
    private final PackOutput.PathProvider pathProvider;
    private final Map<Block, Function<Block, LootTable.Builder>> functionTable = new HashMap<Block, Function<Block, LootTable.Builder>>();

    public BlockLootProvider(PackOutput packOutput) {
        this.pathProvider = packOutput.m_245269_(PackOutput.Target.DATA_PACK, "loot_tables/blocks");
        for (Block b2 : BuiltInRegistries.f_256975_) {
            ResourceLocation id = BuiltInRegistries.f_256975_.m_7981_((Object)b2);
            if (!"extrabotany".equals(id.m_135827_())) continue;
            if (b2 instanceof SlabBlock) {
                this.functionTable.put(b2, BlockLootProvider::genSlab);
                continue;
            }
            if (!(b2 instanceof FlowerPotBlock)) continue;
            FlowerPotBlock flowerPot = (FlowerPotBlock)b2;
            this.functionTable.put(b2, block -> BlockLootProvider.createPotAndPlantItemTable((ItemLike)flowerPot.m_53560_()));
        }
        this.functionTable.put(ExtrabotanyFlowerBlocks.woodienia, b -> BlockLootProvider.genCopyNbt(b, "cooldown"));
        this.functionTable.put(ExtrabotanyFlowerBlocks.woodieniaFloating, b -> BlockLootProvider.genCopyNbt(b, "cooldown"));
        this.functionTable.put(ExtrabotanyFlowerBlocks.reikarlily, b -> BlockLootProvider.genCopyNbt(b, "cooldown"));
        this.functionTable.put(ExtrabotanyFlowerBlocks.reikarlilyFloating, b -> BlockLootProvider.genCopyNbt(b, "cooldown"));
        this.functionTable.put(ExtrabotanyFlowerBlocks.bellflower, b -> BlockLootProvider.genCopyNbt(b, "passiveDecayTicks"));
        this.functionTable.put(ExtrabotanyFlowerBlocks.bellflowerFloating, b -> BlockLootProvider.genCopyNbt(b, "passiveDecayTicks"));
        this.functionTable.put(ExtrabotanyFlowerBlocks.resoncund, b -> BlockLootProvider.genCopyNbt(b, "soundHeard"));
        this.functionTable.put(ExtrabotanyFlowerBlocks.resoncundFloating, b -> BlockLootProvider.genCopyNbt(b, "soundHeard"));
        this.functionTable.put(ExtrabotanyFlowerBlocks.sunshineLily, b -> BlockLootProvider.genCopyNbt(b, "passiveDecayTicks"));
        this.functionTable.put(ExtrabotanyFlowerBlocks.sunshineLilyFloating, b -> BlockLootProvider.genCopyNbt(b, "passiveDecayTicks"));
        this.functionTable.put(ExtrabotanyFlowerBlocks.moonlightLily, b -> BlockLootProvider.genCopyNbt(b, "passiveDecayTicks"));
        this.functionTable.put(ExtrabotanyFlowerBlocks.moonlightLilyFloating, b -> BlockLootProvider.genCopyNbt(b, "passiveDecayTicks"));
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        HashMap<ResourceLocation, LootTable.Builder> tables = new HashMap<ResourceLocation, LootTable.Builder>();
        for (Block b : BuiltInRegistries.f_256975_) {
            Function<Block, LootTable.Builder> func;
            ResourceLocation id = BuiltInRegistries.f_256975_.m_7981_((Object)b);
            if (!"extrabotany".equals(id.m_135827_()) || (func = this.functionTable.getOrDefault(b, BlockLootProvider::genRegular)) == SKIP) continue;
            tables.put(id, func.apply(b));
        }
        ArrayList<CompletableFuture> output = new ArrayList<CompletableFuture>();
        for (Map.Entry e : tables.entrySet()) {
            Path path = this.pathProvider.m_245731_((ResourceLocation)e.getKey());
            output.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)Deserializers.m_78800_().create().toJsonTree((Object)((LootTable.Builder)e.getValue()).m_79165_(LootContextParamSets.f_81421_).m_79167_()), (Path)path));
        }
        return CompletableFuture.allOf((CompletableFuture[])output.toArray(CompletableFuture[]::new));
    }

    protected static LootTable.Builder genCopyNbt(Block b, String ... tags) {
        LootPoolSingletonContainer.Builder entry = LootItem.m_79579_((ItemLike)b);
        CopyNbtFunction.Builder func = CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_);
        for (String tag : tags) {
            func = func.m_80279_(tag, "BlockEntityTag." + tag);
        }
        LootPool.Builder pool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)entry).m_79080_(ExplosionCondition.m_81661_()).m_79078_((LootItemFunction.Builder)func);
        return LootTable.m_79147_().m_79161_(pool);
    }

    protected static LootTable.Builder genRegular(Block b) {
        LootPoolSingletonContainer.Builder entry = LootItem.m_79579_((ItemLike)b);
        LootPool.Builder pool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)entry).m_79080_(ExplosionCondition.m_81661_());
        return LootTable.m_79147_().m_79161_(pool);
    }

    protected static LootTable.Builder genSlab(Block b) {
        LootPoolSingletonContainer.Builder entry = LootItem.m_79579_((ItemLike)b).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)b).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE)))).m_79078_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_());
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)entry));
    }

    protected static LootTable.Builder createPotAndPlantItemTable(ItemLike plant) {
        LootPool.Builder potPool = LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Blocks.f_50276_)).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(ExplosionCondition.m_81661_());
        LootPool.Builder plantPool = LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)plant)).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(ExplosionCondition.m_81661_());
        return LootTable.m_79147_().m_79161_(potPool).m_79161_(plantPool);
    }

    @NotNull
    public String m_6055_() {
        return "ExtraBotany block loot tables";
    }
}

