/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.data.patchouli;

import com.demonwav.mcdev.annotations.Translatable;
import io.github.lounode.extrabotany.common.lib.RegistryHelper;
import io.github.lounode.extrabotany.data.patchouli.PatchouliEntry;
import io.github.lounode.extrabotany.data.patchouli.page.AbstractPage;
import io.github.lounode.extrabotany.data.patchouli.page.IPatchouliPage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;

public class PatchouliBuilder {
    private final ResourceLocation category;
    private String name;
    private Item icon;
    private int sortNum;
    private ResourceLocation advancement;
    private final List<IPatchouliPage> pages = new ArrayList<IPatchouliPage>();
    private final Map<ResourceLocation, Integer> extraRecipeMappings = new HashMap<ResourceLocation, Integer>();
    private boolean priority;
    private boolean secret;
    private boolean read;
    @Nullable
    private Integer color;

    public PatchouliBuilder(ResourceLocation category, @Translatable String name, ItemLike icon, int sortNum) {
        this.category = category;
        this.name = name;
        this.icon = icon.m_5456_();
        this.sortNum = sortNum;
    }

    public static PatchouliBuilder entry(ResourceLocation category) {
        return new PatchouliBuilder(category, "null", (ItemLike)Items.f_42516_, 0);
    }

    public PatchouliBuilder withName(@Translatable String name) {
        this.name = name;
        return this;
    }

    public PatchouliBuilder withIcon(ItemLike icon) {
        this.icon = icon.m_5456_();
        return this;
    }

    public PatchouliBuilder withSortNum(int sortNum) {
        this.sortNum = sortNum;
        return this;
    }

    public PatchouliBuilder withAdvancement(Advancement advancement) {
        this.advancement = advancement.m_138327_();
        return this;
    }

    public PatchouliBuilder withAdvancement(ResourceLocation advancement) {
        this.advancement = advancement;
        return this;
    }

    public PatchouliBuilder pages(AbstractPage<?> ... page) {
        this.pages.addAll(List.of(page));
        return this;
    }

    public void save(Consumer<PatchouliEntry> consumer, ResourceLocation id) {
        consumer.accept(new PatchouliEntry(this.category, this.name, this.icon, this.pages, ResourceLocation.m_214293_((String)this.category.m_135815_(), (String)id.m_135815_()), this.sortNum, this.advancement, this.extraRecipeMappings, this.priority, this.secret, this.read, this.color));
    }

    public PatchouliBuilder extraRecipeMapping(Item item, int pageNum) {
        if (item == Items.f_41852_) {
            return this;
        }
        ResourceLocation location = RegistryHelper.getRegistryName(item);
        this.extraRecipeMappings.put(location, pageNum);
        return this;
    }

    public PatchouliBuilder extraRecipeMapping(Block block, int pageNum) {
        if (block == Blocks.f_50016_) {
            return this;
        }
        ResourceLocation location = RegistryHelper.getRegistryName(block);
        this.extraRecipeMappings.put(location, pageNum);
        return this;
    }

    public PatchouliBuilder priority() {
        this.priority = true;
        return this;
    }

    public PatchouliBuilder secret() {
        this.secret = true;
        return this;
    }

    public PatchouliBuilder defaultRead() {
        this.read = true;
        return this;
    }

    public PatchouliBuilder color(int color) {
        this.color = color;
        return this;
    }
}

