/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.data.patchouli;

import com.demonwav.mcdev.annotations.Translatable;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lounode.extrabotany.common.lib.RegistryHelper;
import io.github.lounode.extrabotany.data.patchouli.page.IPatchouliPage;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;

public class PatchouliEntry {
    JsonObject object = new JsonObject();
    private ResourceLocation id;

    public PatchouliEntry(ResourceLocation category, @Translatable String name, Item icon, List<IPatchouliPage> pages, ResourceLocation id, int sortNum, ResourceLocation advancement, Map<ResourceLocation, Integer> extraRecipeMappings, boolean priority, boolean secret, boolean read, @Nullable Integer color) {
        this.object.addProperty("category", category.toString());
        this.object.addProperty("name", name);
        this.object.addProperty("icon", RegistryHelper.getRegistryName(icon.m_5456_()).toString());
        if (sortNum != 0) {
            this.object.addProperty("sortnum", (Number)sortNum);
        }
        if (advancement != null) {
            this.object.addProperty("advancement", advancement.toString());
        }
        JsonArray pagesJArray = new JsonArray();
        for (IPatchouliPage page : pages) {
            pagesJArray.add((JsonElement)page.build());
        }
        this.object.add("pages", (JsonElement)pagesJArray);
        if (!extraRecipeMappings.isEmpty()) {
            JsonObject mappings = new JsonObject();
            for (Map.Entry<ResourceLocation, Integer> mapping : extraRecipeMappings.entrySet()) {
                mappings.addProperty(mapping.getKey().toString(), (Number)mapping.getValue());
            }
            this.object.add("extra_recipe_mappings", (JsonElement)mappings);
        }
        if (priority) {
            this.object.addProperty("priority", Boolean.valueOf(true));
        }
        if (secret) {
            this.object.addProperty("secret", Boolean.valueOf(true));
        }
        if (read) {
            this.object.addProperty("read_by_default", Boolean.valueOf(true));
        }
        if (color != null) {
            this.object.addProperty("entry_color", color.toString());
        }
        this.id = id;
    }

    public ResourceLocation getID() {
        return this.id;
    }

    public JsonObject serializeEntry() {
        return this.object;
    }
}

