/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.data.patchouli;

import com.demonwav.mcdev.annotations.Translatable;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import io.github.lounode.extrabotany.data.patchouli.PatchouliEntry;
import io.github.lounode.extrabotany.data.patchouli.page.patchouli.CraftingPage;
import io.github.lounode.extrabotany.data.patchouli.page.patchouli.EmptyPage;
import io.github.lounode.extrabotany.data.patchouli.page.patchouli.MultiBlockPage;
import io.github.lounode.extrabotany.data.patchouli.page.patchouli.SpotlightPage;
import io.github.lounode.extrabotany.data.patchouli.page.patchouli.TextPage;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public abstract class PatchouliProvider
implements DataProvider {
    protected PackOutput packOutput;

    public PatchouliProvider(PackOutput packOutput) {
        this.packOutput = packOutput;
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        HashSet checkDuplicates = Sets.newHashSet();
        ArrayList output = new ArrayList();
        this.buildEntries(entry -> {
            if (!checkDuplicates.add(entry.getID())) {
                throw new IllegalStateException("Duplicate entry " + String.valueOf(entry.getID()));
            }
            output.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)entry.serializeEntry(), (Path)this.getOutputPath((PatchouliEntry)entry)));
        });
        return CompletableFuture.allOf((CompletableFuture[])output.toArray(CompletableFuture[]::new));
    }

    protected abstract Path getOutputPath(PatchouliEntry var1);

    protected abstract void buildEntries(Consumer<PatchouliEntry> var1);

    protected EmptyPage empty() {
        return new EmptyPage();
    }

    protected TextPage text(@Translatable String text) {
        return new TextPage(text);
    }

    protected CraftingPage crafting(ItemLike itemLike) {
        return new CraftingPage(itemLike);
    }

    protected CraftingPage crafting(String recipe) {
        return new CraftingPage(recipe);
    }

    protected SpotlightPage spotlight(ItemLike itemLike) {
        return new SpotlightPage(itemLike).linkRecipe(true);
    }

    protected MultiBlockPage multiBlock(@Translatable String name, String[][] pattern) {
        return new MultiBlockPage(name, pattern);
    }

    @NotNull
    public String m_6055_() {
        return "Patchouli Provider";
    }
}

