/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.data.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.github.lounode.extrabotany.common.crafting.ExtraBotanyRecipeTypes;
import io.github.lounode.extrabotany.common.item.ExtraBotanyItems;
import io.github.lounode.extrabotany.common.lib.ExtraBotanyTags;
import io.github.lounode.extrabotany.common.lib.ResourceLocationHelper;
import io.github.lounode.extrabotany.data.recipes.ExtraBotanyRecipeProvider;
import java.util.function.Consumer;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.helper.ItemNBTHelper;

public class PedestalRecipeProvider
extends ExtraBotanyRecipeProvider {
    public PedestalRecipeProvider(PackOutput packOutput) {
        super(packOutput);
    }

    public String m_6055_() {
        return "ExtraBotany pedestal recipes";
    }

    @Override
    protected void buildRecipes(Consumer<FinishedRecipe> consumer) {
        consumer.accept(new FinishedPedestalRecipe(this.id("gilded_potato_mashed"), new ItemStack((ItemLike)ExtraBotanyItems.gildedPotatoMashed), Ingredient.m_43929_((ItemLike[])new ItemLike[]{ExtraBotanyItems.gildedPotato})));
        consumer.accept(new FinishedPedestalRecipe(this.id("spirit_fragment"), new ItemStack((ItemLike)ExtraBotanyItems.spiritFragment), Ingredient.m_43929_((ItemLike[])new ItemLike[]{ExtraBotanyItems.spiritFuel}), Ingredient.m_204132_(ExtraBotanyTags.Items.HAMMERS), 10, 5));
    }

    protected ResourceLocation id(String s) {
        return ResourceLocationHelper.prefix("pedestal_smash/" + s);
    }

    protected static class FinishedPedestalRecipe
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Ingredient input;
        private final ItemStack output;
        private final Ingredient hammer;
        private final int strike;
        private final int exp;

        public FinishedPedestalRecipe(ResourceLocation id, ItemStack output, Ingredient input, @Nullable Ingredient hammer, int strike, int experience) {
            this.id = id;
            this.output = output;
            this.input = input;
            this.hammer = hammer == null ? Ingredient.m_204132_(ExtraBotanyTags.Items.HAMMERS) : hammer;
            this.strike = strike;
            this.exp = experience;
        }

        public FinishedPedestalRecipe(ResourceLocation id, ItemStack output, Ingredient input) {
            this(id, output, input, null, 5, 5);
        }

        public void m_7917_(JsonObject json) {
            json.add("input", this.input.m_43942_());
            json.add("output", (JsonElement)ItemNBTHelper.serializeStack((ItemStack)this.output));
            json.add("smash_tools", this.hammer.m_43942_());
            json.add("strike", (JsonElement)new JsonPrimitive((Number)this.strike));
            json.add("exp", (JsonElement)new JsonPrimitive((Number)this.exp));
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return ExtraBotanyRecipeTypes.PEDESTAL_SMASH_SERIALIZER;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

