/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.data.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lounode.extrabotany.common.crafting.ExtraBotanyRecipeTypes;
import io.github.lounode.extrabotany.common.lib.ResourceLocationHelper;
import io.github.lounode.extrabotany.data.recipes.ExtraBotanyRecipeProvider;
import java.util.function.Consumer;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.crafting.StateIngredientHelper;

public class StonesiaProvider
extends ExtraBotanyRecipeProvider {
    public StonesiaProvider(PackOutput packOutput) {
        super(packOutput);
    }

    @Override
    protected void buildRecipes(Consumer<FinishedRecipe> consumer) {
        consumer.accept(new Result(this.id("stone"), StonesiaProvider.forTag((TagKey<Block>)BlockTags.f_13061_), 20));
        consumer.accept(new Result(this.id("cobblestone"), StateIngredientHelper.combine((StateIngredient)StonesiaProvider.forTag(ResourceLocationHelper.location("c", "cobblestone")), (StateIngredient)StonesiaProvider.forTag(ResourceLocationHelper.location("forge", "cobblestone"))), 10));
        consumer.accept(new Result(this.id("coal_ore"), StonesiaProvider.vanillaOre((TagKey<Block>)BlockTags.f_144262_), 305));
        consumer.accept(new Result(this.id("iron_ore"), StonesiaProvider.vanillaOre((TagKey<Block>)BlockTags.f_144258_), 370));
        consumer.accept(new Result(this.id("diamond_ore"), StonesiaProvider.vanillaOre((TagKey<Block>)BlockTags.f_144259_), 750));
        consumer.accept(new Result(this.id("redstone_ore"), StonesiaProvider.vanillaOre((TagKey<Block>)BlockTags.f_144260_), 330));
        consumer.accept(new Result(this.id("lapis_ore"), StonesiaProvider.vanillaOre((TagKey<Block>)BlockTags.f_144261_), 290));
        consumer.accept(new Result(this.id("gold_ore"), StonesiaProvider.vanillaOre((TagKey<Block>)BlockTags.f_13043_), 580));
        consumer.accept(new Result(this.id("emerald_ore"), StonesiaProvider.vanillaOre((TagKey<Block>)BlockTags.f_144263_), 690));
        consumer.accept(new Result(this.id("copper_ore"), StonesiaProvider.vanillaOre((TagKey<Block>)BlockTags.f_144264_), 320));
        consumer.accept(new Result(this.id("quartz_ore"), StonesiaProvider.ore("quartz"), 340));
        consumer.accept(new Result(this.id("tin_ore"), StonesiaProvider.ore("tin"), 320));
        consumer.accept(new Result(this.id("aluminum_ore"), StonesiaProvider.ore("aluminum"), 390));
        consumer.accept(new Result(this.id("lead_ore"), StonesiaProvider.ore("lead"), 390));
        consumer.accept(new Result(this.id("nickel_ore"), StonesiaProvider.ore("nickel"), 480));
        consumer.accept(new Result(this.id("silver_ore"), StonesiaProvider.ore("silver"), 580));
        consumer.accept(new Result(this.id("zinc_ore"), StonesiaProvider.ore("zinc"), 340));
        consumer.accept(new Result(this.id("platinum_ore"), StonesiaProvider.ore("platinum"), 800));
        consumer.accept(new Result(this.id("uranium_ore"), StonesiaProvider.ore("uranium"), 580));
        consumer.accept(new Result(this.id("osmium_ore"), StonesiaProvider.ore("osmium"), 450));
        consumer.accept(new Result(this.id("cinnabar_ore"), StonesiaProvider.ore("cinnabar"), 470));
        consumer.accept(new Result(this.id("sulfur_ore"), StonesiaProvider.ore("sulfur"), 290));
        consumer.accept(new Result(this.id("apatite_ore"), StonesiaProvider.ore("apatite"), 100));
        consumer.accept(new Result(this.id("niter_ore"), StonesiaProvider.ore("niter"), 470));
        consumer.accept(new Result(this.id("tungsten_ore"), StonesiaProvider.ore("tungsten"), 580));
        consumer.accept(new Result(this.id("ruby_ore"), StonesiaProvider.ore("ruby"), 800));
        consumer.accept(new Result(this.id("sapphire_ore"), StonesiaProvider.ore("sapphire"), 800));
        consumer.accept(new Result(this.id("iridium_ore"), StonesiaProvider.ore("iridium"), 800));
    }

    protected ResourceLocation id(String id) {
        return ResourceLocationHelper.prefix("stonesia/" + id);
    }

    protected static StateIngredient forBlock(Block block) {
        return StateIngredientHelper.of((Block)block);
    }

    protected static StateIngredient forTag(ResourceLocation tag) {
        return StateIngredientHelper.of((ResourceLocation)tag);
    }

    protected static StateIngredient forTag(TagKey<Block> tag) {
        return StateIngredientHelper.of(tag);
    }

    protected static StateIngredient ore(String id) {
        return StateIngredientHelper.combine((StateIngredient)StonesiaProvider.forTag(ResourceLocationHelper.location("c", "ores/" + id)), (StateIngredient)StonesiaProvider.forTag(ResourceLocationHelper.location("forge", "ores/" + id)));
    }

    protected static StateIngredient vanillaOre(TagKey<Block> tag) {
        StateIngredient modTagIngredient = StonesiaProvider.ore(tag.f_203868_().m_135815_().replace("_ores", ""));
        return StateIngredientHelper.combine((StateIngredient)StonesiaProvider.forTag(tag), (StateIngredient)modTagIngredient);
    }

    public String m_6055_() {
        return "Extrabotany Stonesia recipes";
    }

    protected static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final StateIngredient input;
        private final int outputMana;

        public Result(ResourceLocation id, StateIngredient input, int outputMana) {
            this.id = id;
            this.input = input;
            this.outputMana = outputMana;
        }

        public void m_7917_(JsonObject json) {
            json.add("input", (JsonElement)this.input.serialize());
            json.addProperty("outputMana", (Number)this.outputMana);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return ExtraBotanyRecipeTypes.STONESIA_SERIALIZER;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

