/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.forge;

import io.github.lounode.extrabotany.common.block.flower.generating.BellflowerBlockEntity;
import io.github.lounode.extrabotany.xplat.ExtraBotanyConfig;
import java.util.List;
import java.util.UUID;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.botania.xplat.XplatAbstractions;

@Mod.EventBusSubscriber(modid="extrabotany", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ForgeExtrabotanyConfig {
    public static final Client CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;
    private static final Common COMMON;
    private static final ForgeConfigSpec COMMON_SPEC;

    public static void setup(ModLoadingContext context) {
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)COMMON_SPEC);
        ExtraBotanyConfig.setCommon(COMMON);
        if (XplatAbstractions.INSTANCE.isPhysicalClient()) {
            context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_SPEC);
            ExtraBotanyConfig.setClient(CLIENT);
        }
    }

    @SubscribeEvent
    public static void onConfigLoad(ModConfigEvent.Loading evt) {
        ModConfig config = evt.getConfig();
        if (config.getType() == ModConfig.Type.COMMON && config.getModId().equals("extrabotany")) {
            ExtraBotanyConfig.resetPatchouliFlags();
        }
    }

    @SubscribeEvent
    public static void onConfigLoad(ModConfigEvent.Reloading evt) {
        ModConfig config = evt.getConfig();
        if (config.getType() == ModConfig.Type.COMMON && config.getModId().equals("extrabotany")) {
            ExtraBotanyConfig.resetPatchouliFlags();
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    private static class Common
    implements ExtraBotanyConfig.ConfigAccess {
        public final ForgeConfigSpec.BooleanValue disableGaiaDisArm;
        public final ForgeConfigSpec.BooleanValue enableTelemetry;
        public final ForgeConfigSpec.ConfigValue<String> telemetryUUID;
        public final ForgeConfigSpec.ConfigValue<String> fakePlayerId;
        public final ForgeConfigSpec.ConfigValue<List<? extends Integer>> woodieniaRange;
        public final ForgeConfigSpec.IntValue woodieniaCooldown;
        public final ForgeConfigSpec.IntValue woodieniaMaxMana;
        public final ForgeConfigSpec.IntValue woodieniaWorkManaCost;
        public final ForgeConfigSpec.IntValue reikarlilyMaxMana;
        public final ForgeConfigSpec.IntValue reikarlilyProduceCooldown;
        public final ForgeConfigSpec.IntValue reikarlilyProduceMana;
        public final ForgeConfigSpec.IntValue reikarlilySpawnLightningCooldown;
        public final ForgeConfigSpec.IntValue reikarlilyPassiveGenerateTime;
        public final ForgeConfigSpec.IntValue reikarlilyPassiveGenerateMana;
        public final ForgeConfigSpec.IntValue tradeOrchidMaxMana;
        public final ForgeConfigSpec.IntValue tradeOrchidManaCost;
        public final ForgeConfigSpec.IntValue tradeOrchidCooldown;
        public final ForgeConfigSpec.DoubleValue tradeOrchidDiscountPercentage;
        public final ForgeConfigSpec.IntValue bellflowerMaxMana;
        public final ForgeConfigSpec.DoubleValue bellflowerGenerateModify;
        public final ForgeConfigSpec.IntValue annoyingflowerMaxMana;
        public final ForgeConfigSpec.IntValue annoyingflowerFishingCost;
        public final ForgeConfigSpec.IntValue annoyingflowerCooldown;
        public final ForgeConfigSpec.IntValue annoyingflowerFoodBoostMax;
        public final ForgeConfigSpec.IntValue annoyingflowerFoodBoostTimes;
        public final ForgeConfigSpec.DoubleValue annoyingflowerFoodBoostCooldownMultiplier;
        public final ForgeConfigSpec.IntValue stonesiaMaxMana;
        public final ForgeConfigSpec.IntValue stonesiaCooldown;
        public final ForgeConfigSpec.IntValue edelweissMaxMana;
        public final ForgeConfigSpec.IntValue edelweissCooldown;
        public final ForgeConfigSpec.IntValue resoncundMaxMana;
        public final ForgeConfigSpec.IntValue resoncundLossPerHeard;
        public final ForgeConfigSpec.IntValue sunshineLilyMaxMana;
        public final ForgeConfigSpec.IntValue sunshineLilyProduceMana;
        public final ForgeConfigSpec.IntValue moonlightLilyMaxMana;
        public final ForgeConfigSpec.IntValue moonlightLilyProduceMana;
        public final ForgeConfigSpec.IntValue twinstarMaxMana;
        public final ForgeConfigSpec.IntValue twinstarMaxTemperature;
        public final ForgeConfigSpec.IntValue twinstarMinTemperature;
        public final ForgeConfigSpec.IntValue omnivioletMaxMana;
        public final ForgeConfigSpec.IntValue tinkleMaxMana;
        public final ForgeConfigSpec.IntValue tinkleProduceMana;
        public final ForgeConfigSpec.IntValue bloodEnchantressMaxMana;
        public final ForgeConfigSpec.IntValue bloodEnchantressProduceMana;
        public final ForgeConfigSpec.IntValue serenitianRange;
        public final ForgeConfigSpec.IntValue mirrowtuniaMaxMana;
        public final ForgeConfigSpec.IntValue mirrowtuniaEffectCost;
        public final ForgeConfigSpec.IntValue necrofleurMaxMana;
        public final ForgeConfigSpec.IntValue manalinkTransferSpeed;
        public final ForgeConfigSpec.IntValue enchanterTransformCost;
        public final ForgeConfigSpec.IntValue enchanterConsumeSpeed;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> gaiaSpawnUnCheckList;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.push("server");
            builder.push("telemetry");
            this.enableTelemetry = builder.comment("\u6211\u4eec\u4f7f\u7528\u9065\u6d4b\u6570\u636e\u6765\u63d0\u4f9b\u66f4\u597d\u7684\u6e38\u73a9\u4f53\u9a8c\u3002\n\u4ee5\u4e0b\u6570\u636e\u5728\u60a8\u7684\u6e38\u73a9\u8fc7\u7a0b\u4e2d\u5c06\u88ab\u6536\u96c6\uff1a\n\t- \u76d6\u4e9a\u4e09\u901a\u8fc7\u7387\n\t- \u5176\u4ed6...\n\n\u60a8\u53ef\u4ee5\u5728 https://github.com/Lounode/Extrabotany \u4e0a\u627e\u5230\u66f4\u591a\n\u5982\u679c\u60a8\u4e0d\u60f3\u88ab\u6536\u96c6\u8fd9\u4e9b\u6570\u636e\uff0c\u5728\u4e0b\u65b9\u5c06\u914d\u7f6e\u9879\u6539\u4e3a false\n\nWe use telemetry data to provide a better gameplay experience.\nThe following data will be collected during your play session:\n\t- Gaia III completion rate\n\t- etc...\n\nFind more on: https://github.com/Lounode/Extrabotany\nIf you prefer not to participate, set the option below to false").define("enableTelemetry", true);
            this.telemetryUUID = builder.comment("\u9065\u6d4b\u6570\u636eUUID\nThe UUID of the telemetry data").define("telemetryUUID", (Object)UUID.randomUUID().toString());
            builder.pop();
            builder.push("gaia");
            this.disableGaiaDisArm = builder.comment("\u8bbe\u4e3a true \u6765\u7981\u7528\u76d6\u4e9a\u7684\u7f34\u68b0\u6280\u80fd\nSet true to disable Gaia's disarm").define("disableGaiaDisarm", false);
            this.gaiaSpawnUnCheckList = builder.comment("\u76d6\u4e9a\u4e09\u751f\u6210\u65f6\u4e0d\u68c0\u67e5\u7684ModID\u6216\u8005\u7269\u54c1\n\u793a\u4f8b\uff1aminecraft, sophisticatedbackpacks:backpack\nItems or ModIDs that gaia ignore to check when spawn\ne.g. minecraft, sophisticatedbackpacks:backpack").defineList("gaiaSpawnUnCheckList", List.of("minecraft", "botania", "extrabotany"), o -> o instanceof String);
            builder.pop();
            builder.push("fakePlayer");
            this.fakePlayerId = builder.comment("\u5047\u73a9\u5bb6ID\uff08\u7528\u4e8e\u6743\u9650\u914d\u7f6e\uff09\nFake Player ID (for permission configuration)").define("fakePlayerId", (Object)"[Extrabotany]");
            builder.pop();
            builder.push("flower");
            builder.comment("\u5546\u53cb\u5170\nTrade Orchid");
            builder.push("tradeOrchid");
            this.tradeOrchidMaxMana = builder.comment("\u6700\u5927\u9b54\u529b\u503c\nMaximum mana").defineInRange("maxMana", 10000, 0, Integer.MAX_VALUE);
            this.tradeOrchidManaCost = builder.comment("\u6bcf\u53ea\u6751\u6c11\u6d88\u8017\u7684\u9b54\u529b\u91cf\nMana cost per villager").defineInRange("manaCost", 1000, 0, Integer.MAX_VALUE);
            this.tradeOrchidCooldown = builder.comment("\u51b7\u5374\u65f6\u95f4(ticks)\nCooldown time in ticks").defineInRange("cooldown", 40, 0, Integer.MAX_VALUE);
            this.tradeOrchidDiscountPercentage = builder.comment("\u6298\u6263\u767e\u5206\u6bd4(\u4ec5\u652f\u6301\u7cbe\u786e\u5230\u4e24\u4f4d\u5c0f\u6570)\n(\u4f8b\u5982\uff1a0.85 = \u516b\u4e94\u6298)\nDiscount percentage (max precision: 0.01)\n(e.g., 0.85 = 15% off)").defineInRange("discountPercentage", 0.5, 0.0, 1.0);
            builder.pop();
            builder.comment("\u4f10\u6728\u82b1\nWoodienia");
            builder.push("woodienia");
            this.woodieniaMaxMana = builder.comment("\u6700\u5927\u9b54\u529b\nMaximum Mana").defineInRange("maxMana", 10000, 0, Integer.MAX_VALUE);
            this.woodieniaWorkManaCost = builder.comment("\u7834\u574f\u539f\u6728\u7684\u9b54\u529b\u6d88\u8017\nCost when break Logs").defineInRange("workManaCost", 200, 0, Integer.MAX_VALUE);
            this.woodieniaRange = builder.comment("\u4ee5\u81ea\u8eab\u4e3a\u4e2d\u5fc3\u7684\u5de5\u4f5c\u8303\u56f4\uff08\u00b1X\u8f74\uff0c+Y\u8f74\uff0c\u00b1Z\u8f74\uff09\nWorking range centered on self (\u00b1X axis, +Y axis, \u00b1Z axis)").defineList("range", List.of(Integer.valueOf(8), Integer.valueOf(16), Integer.valueOf(8)), o -> {
                Integer i;
                return o instanceof Integer && (i = (Integer)o) > 0 && i < Integer.MAX_VALUE;
            });
            this.woodieniaCooldown = builder.comment("\u5de5\u4f5c\u95f4\u9694\nCooldown interval").defineInRange("cooldown", 10, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("\u96f7\u5361\u5170\nReikarlily");
            builder.push("reikarlily");
            this.reikarlilyMaxMana = builder.comment("\u6700\u5927\u9b54\u529b\nMaximum Mana").defineInRange("maxMana", 12000, 0, Integer.MAX_VALUE);
            this.reikarlilyProduceCooldown = builder.comment("\u96f7\u51fb\u540e\u518d\u6b21\u4ea7\u51fa\u9b54\u529b\u7684\u51b7\u5374\u65f6\u95f4\nCooldown time for regenerating mana after a lightning strike").defineInRange("produceCooldown", 3600, 0, Integer.MAX_VALUE);
            this.reikarlilyProduceMana = builder.comment("\u96f7\u51fb\u751f\u6210\u7684\u9b54\u529b\u91cf\nMana generated per lightning strike").defineInRange("produceMana", 12000, 0, Integer.MAX_VALUE);
            this.reikarlilyPassiveGenerateTime = builder.comment("\u96f7\u51fb\u540e\u88ab\u52a8\u751f\u6210\u9b54\u529b\u7684\u65f6\u95f4\nPassive mana generation duration after lightning strike").defineInRange("passiveGenerateTime", 1500, 0, Integer.MAX_VALUE);
            this.reikarlilyPassiveGenerateMana = builder.comment("\u96f7\u51fb\u540e\u6bcfTick\u88ab\u52a8\u751f\u6210\u7684\u9b54\u529b\u91cf\nMana generated per passive tick").defineInRange("passiveGenerateMana", 45, 0, Integer.MAX_VALUE);
            this.reikarlilySpawnLightningCooldown = builder.comment("\u96e8\u5929\u751f\u6210\u95ea\u7535\u7684\u51b7\u5374\u65f6\u95f4\nCooldown for spawning lightning when raining").defineInRange("spawnLightningCooldown", 3600, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("\u98ce\u94c3\u8349\nBellflower");
            builder.push("bellflower");
            this.bellflowerMaxMana = builder.comment("\u6700\u5927\u9b54\u529b\u503c\nMaximum mana").defineInRange("maxMana", BellflowerBlockEntity.MAX_MANA, 0, Integer.MAX_VALUE);
            this.bellflowerGenerateModify = builder.comment("\u9b54\u529b\u751f\u6210\u4fee\u6b63\u503c\nMana generation modifier").defineInRange("generateModify", 1.0, 0.0, 2.147483647E9);
            builder.pop();
            builder.comment("\u795e\u70e6\u82b1\nAnnoying Flower");
            builder.push("annoyingflower");
            this.annoyingflowerMaxMana = builder.comment("\u6700\u5927\u9b54\u529b\u503c\nMaximum mana").defineInRange("maxMana", 1000, 0, Integer.MAX_VALUE);
            this.annoyingflowerFishingCost = builder.comment("\u9493\u9c7c\u6d88\u8017\u7684\u9b54\u529b\u91cf\nMana cost per fishing").defineInRange("fishingCost", 300, 0, Integer.MAX_VALUE);
            this.annoyingflowerCooldown = builder.comment("\u5de5\u4f5c\u51b7\u5374\u65f6\u95f4(ticks)\nCooldown time in ticks").defineInRange("cooldown", 900, 0, Integer.MAX_VALUE);
            this.annoyingflowerFoodBoostMax = builder.comment("\u6700\u5927\u98df\u7269\u52a0\u6210\u6b21\u6570\nMaximum food boost").defineInRange("foodBoostMax", 12, 0, Integer.MAX_VALUE);
            this.annoyingflowerFoodBoostTimes = builder.comment("\u6bcf\u6b21\u8fdb\u98df\u589e\u52a0\u7684\u6b21\u6570\nBoost added per food consumed").defineInRange("foodBoostPerEat", 3, 0, Integer.MAX_VALUE);
            this.annoyingflowerFoodBoostCooldownMultiplier = builder.comment("\u98df\u7269\u52a0\u6210\u65f6\u7684\u51b7\u5374\u65f6\u95f4\u4e58\u6570\nCooldown multiplier when food boosted").defineInRange("foodBoostCooldownMultiplier", 0.4, 0.0, 1.0);
            builder.pop();
            builder.comment("\u77f3\u4e2d\u59ec\nStonesia");
            builder.push("stonesia");
            this.stonesiaMaxMana = builder.comment("\u6700\u5927\u9b54\u529b\u503c\nMaximum mana").defineInRange("maxMana", 3200, 0, Integer.MAX_VALUE);
            this.stonesiaCooldown = builder.comment("\u51b7\u5374\u65f6\u95f4(ticks)\nCooldown time in ticks").defineInRange("cooldown", 40, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("\u96ea\u7ed2\u82b1\nEdelweiss");
            builder.push("edelweiss");
            this.edelweissMaxMana = builder.comment("\u6700\u5927\u9b54\u529b\u503c\nMaximum mana").defineInRange("maxMana", 12800, 0, Integer.MAX_VALUE);
            this.edelweissCooldown = builder.comment("\u51b7\u5374\u65f6\u95f4(ticks)\nCooldown time in ticks").defineInRange("cooldown", 40, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("\u56de\u97f3\u82b1\nResoncund");
            builder.push("resoncund");
            this.resoncundMaxMana = builder.comment("\u6700\u5927\u9b54\u529b\u503c\nMaximum mana").defineInRange("maxMana", 1200, 0, Integer.MAX_VALUE);
            this.resoncundLossPerHeard = builder.comment("\u540c\u79cd\u58f0\u97f3\u91cd\u590d\u542c\u5230\u540e\u7684\u9b54\u529b\u751f\u4ea7\u8870\u51cf\nMana produce decreases per same sound heard").defineInRange("lossPerHeard", 50, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("\u65e5\u66dc\u767e\u5408\nSunshine Lily");
            builder.push("sunshineLily");
            this.sunshineLilyMaxMana = builder.comment("\u6700\u5927\u9b54\u529b\u503c\nMaximum mana").defineInRange("maxMana", 200, 0, Integer.MAX_VALUE);
            this.sunshineLilyProduceMana = builder.comment("\u6bcf\u6b21\u751f\u6210\u7684\u9b54\u529b\u91cf\nMana generated per produce").defineInRange("produceMana", 2, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("\u6708\u8000\u767e\u5408\nMoonlight Lily");
            builder.push("moonlightLily");
            this.moonlightLilyMaxMana = builder.comment("\u6700\u5927\u9b54\u529b\u503c\nMaximum mana").defineInRange("maxMana", 200, 0, Integer.MAX_VALUE);
            this.moonlightLilyProduceMana = builder.comment("\u6bcf\u6b21\u751f\u6210\u7684\u9b54\u529b\u91cf\nMana generated per produce").defineInRange("produceMana", 1, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("\u53cc\u5b50\u5170\nTwinstar");
            builder.push("twinstar");
            this.twinstarMaxMana = builder.comment("\u6700\u5927\u9b54\u529b\u503c\nMaximum mana").defineInRange("maxMana", 1000, 0, Integer.MAX_VALUE);
            this.twinstarMaxTemperature = builder.comment("\u6700\u5927\u63a5\u53d7\u6d41\u4f53\u6e29\u5ea6\nMaximum accepted temperature cap for liquid").defineInRange("maxTemperatureCap", Integer.MAX_VALUE, 0, Integer.MAX_VALUE);
            this.twinstarMinTemperature = builder.comment("\u6700\u4f4e\u63a5\u53d7\u6d41\u4f53\u6e29\u5ea6\nMinimum accepted temperature cap for liquid").defineInRange("minTemperatureCap", 0, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("\u5168\u77e5\u747e\nOmniviolet");
            builder.push("omniviolet");
            this.omnivioletMaxMana = builder.comment("\u6700\u5927\u9b54\u529b\u503c\nMaximum mana").defineInRange("maxMana", 1500, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("\u53ee\u5f53\u82b1\nTinkle");
            builder.push("tinkle");
            this.tinkleMaxMana = builder.comment("\u6700\u5927\u9b54\u529b\u503c\nMaximum mana").defineInRange("maxMana", 1000, 0, Integer.MAX_VALUE);
            this.tinkleProduceMana = builder.comment("\u6bcf\u6b21\u751f\u6210\u7684\u9b54\u529b\u91cf\nMana generated per produce").defineInRange("produceMana", 100, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("\u9c9c\u8840\u5996\u59ec\nBlood Enchantress");
            builder.push("bloodEnchantress");
            this.bloodEnchantressMaxMana = builder.comment("\u6700\u5927\u9b54\u529b\u503c\nMaximum mana").defineInRange("maxMana", 800, 0, Integer.MAX_VALUE);
            this.bloodEnchantressProduceMana = builder.comment("\u6bcf\u6b21\u751f\u6210\u7684\u9b54\u529b\u91cf\nMana generated per produce").defineInRange("produceMana", 22, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("\u6c38\u5bc2\u9f99\u80c6\nSerenitian");
            builder.push("serenitian");
            this.serenitianRange = builder.comment("\u4f5c\u7528\u8303\u56f4(\u65b9\u5757\u534a\u5f84)\nWorking range in blocks").defineInRange("range", 3, 1, 16);
            builder.pop();
            builder.comment("\u955c\u59ec\nMirrowtunia");
            builder.push("mirrowtunia");
            this.mirrowtuniaMaxMana = builder.comment("\u6700\u5927\u9b54\u529b\u503c\nMaximum mana").defineInRange("maxMana", 2000, 0, Integer.MAX_VALUE);
            this.mirrowtuniaEffectCost = builder.comment("\u65bd\u52a0\u6548\u679c\u6d88\u8017\u7684\u9b54\u529b\u91cf\nMana cost per effect").defineInRange("effectCost", 100, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("\u6b7b\u4e4b\u82b1\nNecrofleur");
            builder.push("necrofleur");
            this.necrofleurMaxMana = builder.comment("\u6700\u5927\u9b54\u529b\u503c\nMaximum mana").defineInRange("maxMana", 200, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("\u9b54\u94fe\u661f\nManalink");
            builder.push("manalink");
            this.manalinkTransferSpeed = builder.comment("\u9b54\u529b\u4f20\u8f93\u901f\u5ea6\nMana transfer speed").defineInRange("transferSpeed", 400, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("\u8574\u9b54\u747e\nEnchanter");
            builder.push("enchanter");
            this.enchanterTransformCost = builder.comment("\u8f6c\u6362\u8349\u65b9\u5757\u4e3a\u8574\u9b54\u571f\u7684\u603b\u6d88\u8017\nTotal mana cost to transform grass to enchanted soil").defineInRange("transformCost", 250000, 0, Integer.MAX_VALUE);
            this.enchanterConsumeSpeed = builder.comment("\u9b54\u529b\u6d88\u8017\u901f\u5ea6\nMana consume speed").defineInRange("consumeSpeed", 400, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.pop();
            builder.pop();
        }

        @Override
        public boolean disableGaiaDisArm() {
            return (Boolean)this.disableGaiaDisArm.get();
        }

        @Override
        public boolean enableTelemetry() {
            return (Boolean)this.enableTelemetry.get();
        }

        @Override
        public String fakePlayerId() {
            return (String)this.fakePlayerId.get();
        }

        @Override
        public String telemetryUUID() {
            return (String)this.telemetryUUID.get();
        }

        @Override
        public int[] woodieniaRange() {
            return ((List)this.woodieniaRange.get()).stream().mapToInt(Integer::intValue).toArray();
        }

        @Override
        public int woodieniaCooldown() {
            return (Integer)this.woodieniaCooldown.get();
        }

        @Override
        public int woodieniaMaxMana() {
            return (Integer)this.woodieniaMaxMana.get();
        }

        @Override
        public int woodieniaWorkManaCost() {
            return (Integer)this.woodieniaWorkManaCost.get();
        }

        @Override
        public int reikarlilyMaxMana() {
            return (Integer)this.reikarlilyMaxMana.get();
        }

        @Override
        public int reikarlilyProduceCooldown() {
            return (Integer)this.reikarlilyProduceCooldown.get();
        }

        @Override
        public int reikarlilyProduceMana() {
            return (Integer)this.reikarlilyProduceMana.get();
        }

        @Override
        public int reikarlilySpawnLightningCooldown() {
            return (Integer)this.reikarlilySpawnLightningCooldown.get();
        }

        @Override
        public int reikarlilyPassiveGenerateTime() {
            return (Integer)this.reikarlilyPassiveGenerateTime.get();
        }

        @Override
        public int reikarlilyPassiveGenerateMana() {
            return (Integer)this.reikarlilyPassiveGenerateMana.get();
        }

        @Override
        public int tradeOrchidMaxMana() {
            return (Integer)this.tradeOrchidMaxMana.get();
        }

        @Override
        public int tradeOrchidManaCost() {
            return (Integer)this.tradeOrchidManaCost.get();
        }

        @Override
        public int tradeOrchidCooldown() {
            return (Integer)this.tradeOrchidCooldown.get();
        }

        @Override
        public double tradeOrchidDiscountPercentage() {
            return (Double)this.tradeOrchidDiscountPercentage.get();
        }

        @Override
        public int bellflowerMaxMana() {
            return (Integer)this.bellflowerMaxMana.get();
        }

        @Override
        public double bellflowerGenerateModify() {
            return (Double)this.bellflowerGenerateModify.get();
        }

        @Override
        public int annoyingflowerMaxMana() {
            return (Integer)this.annoyingflowerMaxMana.get();
        }

        @Override
        public int annoyingflowerFishingCost() {
            return (Integer)this.annoyingflowerFishingCost.get();
        }

        @Override
        public int annoyingflowerCooldown() {
            return (Integer)this.annoyingflowerCooldown.get();
        }

        @Override
        public int annoyingflowerFoodBoostMax() {
            return (Integer)this.annoyingflowerFoodBoostMax.get();
        }

        @Override
        public int annoyingflowerFoodBoostTimes() {
            return (Integer)this.annoyingflowerFoodBoostTimes.get();
        }

        @Override
        public double annoyingflowerFoodBoostCooldownMultiplier() {
            return (Double)this.annoyingflowerFoodBoostCooldownMultiplier.get();
        }

        @Override
        public int stonesiaMaxMana() {
            return (Integer)this.stonesiaMaxMana.get();
        }

        @Override
        public int stonesiaCooldown() {
            return (Integer)this.stonesiaCooldown.get();
        }

        @Override
        public int edelweissMaxMana() {
            return (Integer)this.edelweissMaxMana.get();
        }

        @Override
        public int edelweissCooldown() {
            return (Integer)this.edelweissCooldown.get();
        }

        @Override
        public int resoncundMaxMana() {
            return (Integer)this.resoncundMaxMana.get();
        }

        @Override
        public int resoncundLossPerHeard() {
            return (Integer)this.resoncundLossPerHeard.get();
        }

        @Override
        public int sunshineLilyMaxMana() {
            return (Integer)this.sunshineLilyMaxMana.get();
        }

        @Override
        public int sunshineLilyProduceMana() {
            return (Integer)this.sunshineLilyProduceMana.get();
        }

        @Override
        public int moonlightLilyMaxMana() {
            return (Integer)this.moonlightLilyMaxMana.get();
        }

        @Override
        public int moonlightLilyProduceMana() {
            return (Integer)this.moonlightLilyProduceMana.get();
        }

        @Override
        public int twinstarMaxMana() {
            return (Integer)this.twinstarMaxMana.get();
        }

        @Override
        public int twinstarMaxTemperature() {
            return (Integer)this.twinstarMaxTemperature.get();
        }

        @Override
        public int twinstarMinTemperature() {
            return (Integer)this.twinstarMinTemperature.get();
        }

        @Override
        public int omnivioletMaxMana() {
            return (Integer)this.omnivioletMaxMana.get();
        }

        @Override
        public int tinkleMaxMana() {
            return (Integer)this.tinkleMaxMana.get();
        }

        @Override
        public int tinkleProduceMana() {
            return (Integer)this.tinkleProduceMana.get();
        }

        @Override
        public int bloodEnchantressMaxMana() {
            return (Integer)this.bloodEnchantressMaxMana.get();
        }

        @Override
        public int bloodEnchantressProduceMana() {
            return (Integer)this.bloodEnchantressProduceMana.get();
        }

        @Override
        public int serenitianRange() {
            return (Integer)this.serenitianRange.get();
        }

        @Override
        public int mirrowtuniaMaxMana() {
            return (Integer)this.mirrowtuniaMaxMana.get();
        }

        @Override
        public int mirrowtuniaEffectCost() {
            return (Integer)this.mirrowtuniaEffectCost.get();
        }

        @Override
        public int necrofleurMaxMana() {
            return (Integer)this.necrofleurMaxMana.get();
        }

        @Override
        public int manalinkTransferSpeed() {
            return (Integer)this.manalinkTransferSpeed.get();
        }

        @Override
        public int enchanterTransformCost() {
            return (Integer)this.enchanterTransformCost.get();
        }

        @Override
        public int enchanterConsumeSpeed() {
            return (Integer)this.enchanterConsumeSpeed.get();
        }

        @Override
        public List<String> gaiaSpawnUnCheckList() {
            return (List)this.gaiaSpawnUnCheckList.get();
        }
    }

    private static class Client
    implements ExtraBotanyConfig.ClientConfigAccess {
        public final ForgeConfigSpec.BooleanValue otakuMode;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.push("client");
            this.otakuMode = builder.comment("\u8bbe\u4e3a true \u6765\u5f00\u542f\u4e8c\u523a\u8788\u6a21\u5f0f\n\uff08\u5c06\u4f1a\u542f\u7528\u4e00\u4e9b\u6d53\u5ea6\u8f83\u9ad8\u3001\u53d1\u766b\u7684\u6587\u672c\u663e\u793a\uff09\n\nSet true to enable Otaku Mode.\n(Enables otaku-style text display)").define("otakuMode", false);
            builder.pop();
        }

        @Override
        public boolean otakuMode() {
            return (Boolean)this.otakuMode.get();
        }
    }
}

