/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.forge.xplat;

import com.mojang.authlib.GameProfile;
import io.github.lounode.extrabotany.api.ExtrabotanyForgeCapabilities;
import io.github.lounode.extrabotany.api.item.NatureEnergyItem;
import io.github.lounode.extrabotany.forge.network.ForgePacketHandler;
import io.github.lounode.extrabotany.network.ExtrabotanyPacket;
import io.github.lounode.extrabotany.xplat.EXplatAbstractions;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.EnchantmentTableBlock;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;
import vazkii.botania.forge.xplat.ForgeXplatImpl;

public class ExForgeXplatImpl
extends ForgeXplatImpl
implements EXplatAbstractions {
    @Override
    public void sendToPlayer(ServerPlayer player, ExtrabotanyPacket packet) {
        ForgePacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
    }

    @Override
    public Packet<ClientGamePacketListener> toVanillaClientboundPacket(ExtrabotanyPacket packet) {
        return ForgePacketHandler.CHANNEL.toVanillaPacket((Object)packet, NetworkDirection.PLAY_TO_CLIENT);
    }

    @Override
    @Nullable
    public NatureEnergyItem findNatureEnergyItem(ItemStack stack) {
        return (NatureEnergyItem)stack.getCapability(ExtrabotanyForgeCapabilities.NATURE_ENERGY_ITEM).orElse(null);
    }

    @Override
    public String getExtraBotanyVersion() {
        return ((ModContainer)ModList.get().getModContainerById("extrabotany").get()).getModInfo().getVersion().toString();
    }

    @Override
    public Player createFakePlayer(ServerLevel level, GameProfile userName) {
        return FakePlayerFactory.get((ServerLevel)level, (GameProfile)userName);
    }

    @Override
    public int getFluidTemperature(Fluid fluid) {
        return fluid.getFluidType().getTemperature();
    }

    @Override
    public float getEnchantPowerBonus(ServerLevel level, BlockPos pos) {
        float j = 0.0f;
        for (BlockPos blockpos : EnchantmentTableBlock.f_207902_) {
            if (!EnchantmentTableBlock.m_207909_((Level)level, (BlockPos)pos, (BlockPos)blockpos)) continue;
            j += level.m_8055_(pos.m_121955_((Vec3i)blockpos)).getEnchantPowerBonus((LevelReader)level, pos.m_121955_((Vec3i)blockpos));
        }
        return j;
    }
}

