/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity;

import com.mojang.serialization.Codec;
import com.pepper.faunify.registry.FaunifyEntities;
import com.pepper.faunify.registry.FaunifySounds;
import java.util.Arrays;
import java.util.List;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class MouseEntity
extends TamableAnimal
implements GeoEntity {
    private static final int STEAL_RADIUS = 10;
    private static final int COOLDOWN_TICKS = 100;
    private static final EntityDataAccessor<Integer> DATA_VARIANT_ID = SynchedEntityData.m_135353_(MouseEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private long lastStealTime = 0L;
    private ItemStack stolenSeed = ItemStack.f_41583_;
    private boolean isRunning = false;
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);

    public MouseEntity(EntityType<? extends TamableAnimal> entityType, Level world) {
        super(entityType, world);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 1.5).m_22268_(Attributes.f_22279_, 0.25);
    }

    public static boolean canSpawn(EntityType<MouseEntity> entityType, LevelAccessor level, MobSpawnType spawnType, BlockPos position, RandomSource random) {
        return Animal.m_218104_(entityType, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)position, (RandomSource)random);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        this.setVariant(Variant.getCommonSpawnVariant(world.m_213780_()));
        super.m_6518_(world, difficulty, spawnReason, spawnData, dataTag);
        if (spawnData == null) {
            spawnData = new AgeableMob.AgeableMobGroupData(false);
        }
        return spawnData;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_VARIANT_ID, (Object)0);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getVariant().id);
        tag.m_128347_("PosX", this.m_20185_());
        tag.m_128347_("PosY", this.m_20186_());
        tag.m_128347_("PosZ", this.m_20189_());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setVariant(Variant.byId(tag.m_128451_("Variant")));
        if (tag.m_128441_("PosX") && tag.m_128441_("PosY") && tag.m_128441_("PosZ")) {
            double posX = tag.m_128459_("PosX");
            double posY = tag.m_128459_("PosY");
            double posZ = tag.m_128459_("PosZ");
            this.m_6034_(posX, posY, posZ);
        }
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.f_19804_.m_135370_(DATA_VARIANT_ID));
    }

    public void setVariant(Variant variant) {
        this.f_19804_.m_135381_(DATA_VARIANT_ID, (Object)variant.id);
    }

    public boolean canSteal() {
        return this.m_9236_().m_46467_() - this.lastStealTime > 100L;
    }

    public void setLastStealTime() {
        this.lastStealTime = this.m_9236_().m_46467_();
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void m_8119_() {
        super.m_8119_();
    }

    public void m_6667_(DamageSource cause) {
        super.m_6667_(cause);
        if (!this.stolenSeed.m_41619_()) {
            this.m_19983_(this.stolenSeed);
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new StealSeedGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.5));
        this.f_21345_.m_25352_(3, (Goal)new BreedGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.35, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42780_}), false));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (item == Items.f_42780_) {
            if (!this.m_27593_() && this.m_146764_() == 0 && !this.m_9236_().f_46443_) {
                this.m_27595_(player);
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == Items.f_42780_;
    }

    public MouseEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob otherParent) {
        MouseEntity babyMouse = (MouseEntity)((EntityType)FaunifyEntities.MOUSE.get()).m_20615_((Level)serverLevel);
        if (babyMouse != null && otherParent instanceof MouseEntity) {
            MouseEntity parent = (MouseEntity)otherParent;
            RandomSource random = this.m_217043_();
            Variant selectedVariant = random.m_188501_() < 0.05f ? Variant.getRareBreedVariant(random) : (random.m_188499_() ? this.getVariant() : parent.getVariant());
            babyMouse.setVariant(selectedVariant);
        }
        return babyMouse;
    }

    protected SoundEvent m_7515_() {
        int soundIndex = this.f_19796_.m_188503_(2);
        switch (soundIndex) {
            case 0: {
                return (SoundEvent)FaunifySounds.MOUSE_IDLE_1.get();
            }
            case 1: {
                return (SoundEvent)FaunifySounds.MOUSE_IDLE_2.get();
            }
        }
        return (SoundEvent)FaunifySounds.MOUSE_IDLE_1.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)FaunifySounds.MOUSE_HURT.get();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    private PlayState predicate(AnimationState<MouseEntity> event) {
        LivingEntity target = this.m_5448_();
        if (target != null && !target.m_6084_()) {
            this.m_6710_(null);
            target = null;
        }
        if (this.isRunning) {
            event.getController().setAnimation(RawAnimation.begin().then("run", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.isFollowingPlayerWithFood()) {
            if (event.isMoving()) {
                event.getController().setAnimation(RawAnimation.begin().then("run", Animation.LoopType.LOOP));
                return PlayState.CONTINUE;
            }
            event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (event.isMoving()) {
            event.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    private boolean isFollowingPlayerWithFood() {
        Player player = this.m_9236_().m_45930_((Entity)this, 10.0);
        if (player != null) {
            ItemStack heldItem = player.m_21205_();
            return heldItem.m_150930_(Items.f_42404_) || heldItem.m_150930_(Items.f_42733_) || heldItem.m_150930_(Items.f_42577_) || heldItem.m_150930_(Items.f_42578_);
        }
        return false;
    }

    public static enum Variant implements StringRepresentable
    {
        FIELD(0, "field", true),
        GREY(1, "grey", true),
        WOOD(2, "wood", true),
        WHITE(3, "white", true),
        BLACK(4, "black", true),
        BROWNBELLY(5, "brownbelly", true),
        ALBINO(6, "albino", false);

        public static final Codec<Variant> CODEC;
        private static final IntFunction<Variant> BY_ID;
        private final int id;
        private final String name;
        private final boolean common;

        private Variant(int id, String name, boolean common) {
            this.id = id;
            this.name = name;
            this.common = common;
        }

        public int getId() {
            return this.id;
        }

        public String m_7912_() {
            return this.name;
        }

        public static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        public static Variant getCommonSpawnVariant(RandomSource random) {
            return Variant.getSpawnVariant(random, true);
        }

        public static Variant getRareBreedVariant(RandomSource random) {
            return Variant.getSpawnVariant(random, false);
        }

        private static Variant getSpawnVariant(RandomSource random, boolean isCommon) {
            Variant[] validVariants = (Variant[])Arrays.stream(Variant.values()).filter(variant -> variant.common == isCommon).toArray(Variant[]::new);
            return (Variant)((Object)Util.m_214670_((Object[])validVariants, (RandomSource)random));
        }

        static {
            CODEC = StringRepresentable.m_216439_(Variant::values);
            BY_ID = ByIdMap.m_262839_(Variant::getId, (Object[])Variant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.CLAMP);
        }
    }

    private static class StealSeedGoal
    extends Goal {
        private final MouseEntity mouse;
        private Player targetPlayer;

        public StealSeedGoal(MouseEntity mouse) {
            this.mouse = mouse;
        }

        public boolean m_8036_() {
            if (!this.mouse.canSteal()) {
                return false;
            }
            List players = this.mouse.m_9236_().m_45976_(Player.class, this.mouse.m_20191_().m_82400_(10.0));
            for (Player player : players) {
                if (!this.hasSeeds(player)) continue;
                this.targetPlayer = player;
                return true;
            }
            return false;
        }

        public void m_8056_() {
            if (this.targetPlayer != null) {
                this.mouse.m_21573_().m_5624_((Entity)this.targetPlayer, 0.75);
            }
        }

        public void m_8037_() {
            if (this.targetPlayer == null || !this.targetPlayer.m_6084_()) {
                return;
            }
            double distance = this.mouse.m_20270_((Entity)this.targetPlayer);
            if (distance > 1.5) {
                this.mouse.m_21573_().m_5624_((Entity)this.targetPlayer, 0.75);
            } else {
                this.stealSeed(this.targetPlayer);
                this.mouse.setLastStealTime();
                this.fleeFrom(this.targetPlayer);
            }
        }

        private boolean hasSeeds(Player player) {
            for (ItemStack stack : player.m_150109_().f_35974_) {
                if (!this.isSeed(stack)) continue;
                return true;
            }
            return false;
        }

        private void stealSeed(Player player) {
            for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
                ItemStack stolen;
                ItemStack stack = (ItemStack)player.m_150109_().f_35974_.get(i);
                if (!this.isSeed(stack)) continue;
                this.mouse.stolenSeed = stolen = stack.m_41620_(1);
                this.mouse.m_5496_((SoundEvent)FaunifySounds.MOUSE_STEAL.get(), 1.0f, 1.0f);
                break;
            }
        }

        private boolean isSeed(ItemStack stack) {
            return stack.m_150930_(Items.f_42404_) || stack.m_150930_(Items.f_42733_) || stack.m_150930_(Items.f_42577_) || stack.m_150930_(Items.f_42578_);
        }

        private void fleeFrom(Player player) {
            this.mouse.isRunning = true;
            Vec3 fleeDirection = this.mouse.m_20182_().m_82546_(player.m_20182_()).m_82541_().m_82490_(20.0);
            this.mouse.m_21573_().m_26519_(this.mouse.m_20185_() + fleeDirection.f_82479_, this.mouse.m_20186_(), this.mouse.m_20189_() + fleeDirection.f_82481_, 2.0);
            if (this.mouse.m_20270_((Entity)player) > 25.0f) {
                this.mouse.isRunning = false;
            }
        }
    }
}

