/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity;

import com.pepper.faunify.registry.FaunifySounds;
import java.util.Comparator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class SilkMothEntity
extends TamableAnimal
implements GeoEntity {
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private BlockPos targetPosition;

    public SilkMothEntity(EntityType<? extends TamableAnimal> entityType, Level world) {
        super(entityType, world);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 1.5).m_22268_(Attributes.f_22279_, 0.25);
    }

    public static boolean canSpawn(EntityType<SilkMothEntity> entityType, LevelAccessor level, MobSpawnType spawnType, BlockPos position, RandomSource random) {
        return Animal.m_218104_(entityType, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)position, (RandomSource)random);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        return spawnData;
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_8097_() {
        super.m_8097_();
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
    }

    protected void m_8024_() {
        super.m_8024_();
        Level level = this.m_9236_();
        if (level.m_46462_()) {
            BlockPos lightSourcePos = this.findHighestPriorityLightSource();
            if (lightSourcePos != null) {
                Vec3 targetAroundLight = this.getDynamicLightTarget(lightSourcePos);
                double distanceSq = this.m_20182_().m_82557_(targetAroundLight);
                if (distanceSq > 2.0) {
                    this.moveTowardsTarget(targetAroundLight);
                }
            } else {
                this.randomMovement();
            }
        } else {
            this.randomMovement();
        }
    }

    private BlockPos findHighestPriorityLightSource() {
        Level level = this.m_9236_();
        BlockPos mothPos = this.m_20183_();
        return BlockPos.m_121990_((BlockPos)mothPos.m_7918_(-15, -15, -15), (BlockPos)mothPos.m_7918_(15, 15, 15)).map(BlockPos::m_7949_).filter(pos -> {
            BlockState state = level.m_8055_(pos);
            return state.m_60791_() >= 8;
        }).min(Comparator.comparingInt(pos -> -level.m_45517_(LightLayer.BLOCK, pos)).thenComparingDouble(pos -> pos.m_123331_((Vec3i)mothPos))).orElse(null);
    }

    private Vec3 getDynamicLightTarget(BlockPos lightPos) {
        int xOffset = this.f_19796_.m_188503_(3) - 1;
        int yOffset = this.f_19796_.m_188503_(3) - 1;
        int zOffset = this.f_19796_.m_188503_(3) - 1;
        if (this.f_19796_.m_188499_()) {
            yOffset += this.f_19796_.m_188499_() ? 2 : -2;
        }
        BlockPos target = lightPos.m_7918_(xOffset, yOffset, zOffset);
        return Vec3.m_82512_((Vec3i)target);
    }

    private void moveTowardsTarget(Vec3 targetPos) {
        Vec3 currentPos = this.m_20182_();
        Vec3 motion = this.m_20184_();
        double dx = targetPos.f_82479_ - currentPos.f_82479_;
        double dy = targetPos.f_82480_ - currentPos.f_82480_;
        double dz = targetPos.f_82481_ - currentPos.f_82481_;
        Vec3 adjustment = new Vec3((Math.signum(dx) * 0.5 - motion.f_82479_) * 0.07, (Math.signum(dy) * 0.7 - motion.f_82480_) * (dy > 0.0 ? 0.12 : 0.08), (Math.signum(dz) * 0.5 - motion.f_82481_) * 0.07);
        Vec3 newMotion = motion.m_82549_(adjustment);
        this.m_20256_(newMotion);
        float targetYaw = (float)(Mth.m_14136_((double)newMotion.f_82481_, (double)newMotion.f_82479_) * 57.29577951308232) - 90.0f;
        float yawDiff = Mth.m_14177_((float)(targetYaw - this.m_146908_()));
        this.f_20902_ = 0.5f;
        this.m_146922_(this.m_146908_() + yawDiff * 0.2f);
    }

    private void randomMovement() {
        if (this.targetPosition == null || this.f_19796_.m_188503_(40) == 0 || this.targetPosition.m_203195_((Position)this.m_20182_(), 1.5)) {
            this.targetPosition = BlockPos.m_274561_((double)(this.m_20185_() + (double)this.f_19796_.m_188503_(9) - 4.0), (double)(this.m_20186_() + (double)this.f_19796_.m_188503_(5) - 2.0), (double)(this.m_20189_() + (double)this.f_19796_.m_188503_(9) - 4.0));
        }
        Vec3 target = Vec3.m_82512_((Vec3i)this.targetPosition);
        this.moveTowardsTarget(target);
    }

    protected void m_7840_(double fallDistance, boolean onGround, BlockState state, BlockPos pos) {
    }

    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob otherParent) {
        return null;
    }

    protected SoundEvent m_7515_() {
        return null;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)FaunifySounds.SILKMOTH_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)FaunifySounds.SILKMOTH_HURT.get();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    private PlayState predicate(AnimationState<SilkMothEntity> event) {
        if (event.isMoving()) {
            event.getController().setAnimation(RawAnimation.begin().then("fly", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }
}

