/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.item;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.world.DragonPosWorldData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.world.ForgeChunkManager;
import org.jetbrains.annotations.NotNull;

public class ItemSummoningCrystal
extends Item {
    public static Map<UUID, ItemSummoningCrystal> DELAYED_SUMMONS = new HashMap<UUID, ItemSummoningCrystal>();
    private UUID dragonUuid;
    private BlockPos dragonTargetPosition;
    private float dragonTargetYaw;
    private Player summoningPlayer;
    private InteractionHand summoningHand;
    private ServerLevel serverWorld;
    private BlockPos dragonOriginPosition;
    private ItemStack stack;
    private long summoningTime = 0L;

    public ItemSummoningCrystal() {
        super(new Item.Properties().m_41487_(1));
    }

    private static CompoundTag getDragonTag(ItemStack stack) {
        if (stack.m_41720_() instanceof ItemSummoningCrystal && stack.m_41783_() != null) {
            for (String tagInfo : stack.m_41783_().m_128431_()) {
                if (!tagInfo.contains("Dragon")) continue;
                return stack.m_41783_().m_128469_(tagInfo);
            }
        }
        return null;
    }

    public static boolean hasDragon(ItemStack stack) {
        return ItemSummoningCrystal.getDragonTag(stack) != null;
    }

    public void m_7836_(ItemStack itemStack, @NotNull Level world, @NotNull Player player) {
        itemStack.m_41751_(new CompoundTag());
    }

    public ItemStack onItemUseFinish(Level worldIn, LivingEntity LivingEntity2) {
        return new ItemStack((ItemLike)this);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        boolean flag = false;
        String desc = "entity.iceandfire.fire_dragon";
        if (stack.m_41720_() == IafItemRegistry.SUMMONING_CRYSTAL_ICE.get()) {
            desc = "entity.iceandfire.ice_dragon";
        }
        if (stack.m_41720_() == IafItemRegistry.SUMMONING_CRYSTAL_LIGHTNING.get()) {
            desc = "entity.iceandfire.lightning_dragon";
        }
        if (stack.m_41783_() != null) {
            for (String tagInfo : stack.m_41783_().m_128431_()) {
                if (!tagInfo.contains("Dragon")) continue;
                CompoundTag dragonTag = stack.m_41783_().m_128469_(tagInfo);
                String dragonName = I18n.m_118938_((String)desc, (Object[])new Object[0]);
                if (!dragonTag.m_128461_("CustomName").isEmpty()) {
                    dragonName = dragonTag.m_128461_("CustomName");
                }
                tooltip.add((Component)Component.m_237110_((String)"item.iceandfire.summoning_crystal.bound", (Object[])new Object[]{dragonName}).m_130940_(ChatFormatting.GRAY));
                flag = true;
            }
        }
        if (!flag) {
            tooltip.add((Component)Component.m_237115_((String)"item.iceandfire.summoning_crystal.desc_0").m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237115_((String)"item.iceandfire.summoning_crystal.desc_1").m_130940_(ChatFormatting.GRAY));
        }
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43725_().f_46443_) {
            return InteractionResult.PASS;
        }
        this.serverWorld = (ServerLevel)context.m_43725_();
        if (this.serverWorld.m_46472_() != Level.f_46428_) {
            return InteractionResult.PASS;
        }
        this.summoningPlayer = context.m_43723_();
        this.summoningHand = context.m_43724_();
        this.stack = this.summoningPlayer.m_21120_(this.summoningHand);
        this.dragonTargetYaw = this.summoningPlayer.m_146908_();
        this.dragonTargetPosition = context.m_8083_().m_121945_(context.m_43719_());
        if (this.stack.m_41720_() != this) {
            return InteractionResult.PASS;
        }
        CompoundTag dragonTag = ItemSummoningCrystal.getDragonTag(this.stack);
        if (dragonTag == null) {
            return InteractionResult.PASS;
        }
        this.dragonUuid = dragonTag.m_128342_("DragonUUID");
        IceAndFire.LOGGER.info("Trying to summon dragon {} {}", (Object)this.dragonUuid, (Object)dragonTag.m_128461_("CustomName"));
        Entity entity = this.serverWorld.m_8791_(this.dragonUuid);
        if (entity != null) {
            this.summonEntity(entity, (Level)this.serverWorld, this.dragonTargetPosition, this.dragonTargetYaw);
            return InteractionResult.PASS;
        }
        if (!IafConfig.chunkLoadSummonCrystal) {
            IceAndFire.LOGGER.info("Dragon entity {} not loaded, and chunk loading is disabled", (Object)this.dragonUuid);
            this.displayClientError();
            return InteractionResult.PASS;
        }
        DragonPosWorldData data = DragonPosWorldData.get((Level)this.serverWorld);
        if (data == null) {
            IceAndFire.LOGGER.warn("Unable to load DragonPosWorldData for world {}", (Object)this.serverWorld);
            this.displayClientError();
            return InteractionResult.PASS;
        }
        this.dragonOriginPosition = data.getDragonPos(this.dragonUuid);
        if (this.dragonOriginPosition == null) {
            IceAndFire.LOGGER.warn("Summoning dragon origin position unknown for dragon {}", (Object)this.dragonUuid);
            this.displayClientError();
            return InteractionResult.PASS;
        }
        ChunkPos pos = new ChunkPos(this.dragonOriginPosition);
        IceAndFire.LOGGER.info("Dragon entity not loaded, loading chunk {}", (Object)pos);
        if (ForgeChunkManager.forceChunk((ServerLevel)this.serverWorld, (String)"iceandfire", (Entity)this.summoningPlayer, (int)pos.f_45578_, (int)pos.f_45579_, (boolean)true, (boolean)false)) {
            this.summoningTime = this.serverWorld.m_46467_();
            DELAYED_SUMMONS.put(this.dragonUuid, this);
        } else {
            IceAndFire.LOGGER.warn("Failed to force load chunk with Dragon {}", (Object)this.dragonUuid);
        }
        return InteractionResult.PASS;
    }

    public void summonEntity(Entity entity, Level worldIn, BlockPos offsetPos, float yaw) {
        DragonPosWorldData data;
        entity.m_7678_((double)offsetPos.m_123341_() + 0.5, (double)offsetPos.m_123342_() + 0.5, (double)offsetPos.m_123343_() + 0.5, yaw, 0.0f);
        if (entity instanceof EntityDragonBase) {
            ((EntityDragonBase)entity).setCrystalBound(false);
        }
        if (IafConfig.chunkLoadSummonCrystal && (data = DragonPosWorldData.get(worldIn)) != null) {
            data.removeDragon(entity.m_20148_());
        }
        this.summoningPlayer.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
        this.summoningPlayer.m_5496_(SoundEvents.f_11983_, 1.0f, 1.0f);
        this.summoningPlayer.m_6674_(this.summoningHand);
        this.summoningPlayer.m_5661_((Component)Component.m_237115_((String)"message.iceandfire.dragonTeleport"), true);
        this.stack.m_41751_(new CompoundTag());
    }

    public void delayedSummon() {
        DELAYED_SUMMONS.remove(this.dragonUuid);
        ChunkPos pos = new ChunkPos(this.dragonOriginPosition);
        long SUMMON_DELAY_TOLERANCE = 2000L;
        if (this.serverWorld.m_46467_() - 2000L > this.summoningTime) {
            IceAndFire.LOGGER.info("Dragon summon timed out for dragon {}; unloading chunk {}", (Object)this.dragonUuid, (Object)pos);
        } else {
            Entity entity = this.serverWorld.m_8791_(this.dragonUuid);
            if (entity != null) {
                if (this.summoningPlayer.m_6084_()) {
                    this.summonEntity(entity, (Level)this.serverWorld, this.dragonTargetPosition, this.dragonTargetYaw);
                    IceAndFire.LOGGER.info("Summoned dragon {} and unloading chunk {}", (Object)this.dragonUuid, (Object)pos);
                } else {
                    IceAndFire.LOGGER.info("Player died since summoning {}; unloading chunk {}", (Object)this.dragonUuid, (Object)pos);
                }
            }
        }
        ForgeChunkManager.forceChunk((ServerLevel)this.serverWorld, (String)"iceandfire", (Entity)this.summoningPlayer, (int)pos.f_45578_, (int)pos.f_45579_, (boolean)false, (boolean)false);
        this.dragonUuid = null;
        this.summoningPlayer = null;
        this.summoningHand = null;
        this.stack = null;
        this.dragonTargetPosition = null;
        this.serverWorld = null;
        this.dragonOriginPosition = null;
        this.summoningTime = 0L;
    }

    private void displayClientError() {
        this.summoningPlayer.m_5661_((Component)Component.m_237115_((String)"message.iceandfire.noDragonTeleport"), true);
    }
}

