/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.world.gen.TypedFeature;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.jetbrains.annotations.NotNull;

public class IafWorldData
extends SavedData {
    private static final String IDENTIFIER = "iceandfire_general";
    private static final EnumMap<FeatureType, ArrayList<Map.Entry<String, BlockPos>>> LAST_GENERATED = new EnumMap(FeatureType.class);

    public IafWorldData() {
    }

    public IafWorldData(CompoundTag tag) {
        this.load(tag);
    }

    public static IafWorldData get(Level world) {
        if (world instanceof ServerLevel) {
            ServerLevel overworld = world.m_7654_().m_129880_(world.m_46472_());
            DimensionDataStorage storage = overworld.m_8895_();
            IafWorldData data = (IafWorldData)storage.m_164861_(IafWorldData::new, IafWorldData::new, IDENTIFIER);
            data.m_77762_();
            return data;
        }
        return null;
    }

    public boolean check(TypedFeature feature, BlockPos position, String id) {
        return this.check(feature.getFeatureType(), position, id);
    }

    public boolean check(FeatureType type, BlockPos position, String id) {
        ArrayList<Map.Entry<String, BlockPos>> entries = LAST_GENERATED.get((Object)type);
        boolean canGenerate = true;
        ArrayList<Map.Entry<String, BlockPos>> toRemove = null;
        for (Map.Entry<String, BlockPos> entry : entries) {
            if (entry.getKey().equals(id)) {
                if (toRemove == null) {
                    toRemove = new ArrayList<Map.Entry<String, BlockPos>>();
                }
                toRemove.add(entry);
            }
            canGenerate = position.m_123331_((Vec3i)entry.getValue()) > IafConfig.dangerousWorldGenSeparationLimit * IafConfig.dangerousWorldGenSeparationLimit;
        }
        if (toRemove != null) {
            entries.removeAll(toRemove);
        }
        if (entries.size() > 5000) {
            IceAndFire.LOGGER.debug("Too many BlockPos entries for feature type {} tracked, removing oldest ones", (Object)type);
            entries.subList(0, 1000).clear();
            entries.trimToSize();
        }
        entries.add(Map.entry(id, position));
        return canGenerate;
    }

    public IafWorldData load(CompoundTag tag) {
        FeatureType[] types;
        for (FeatureType type : types = FeatureType.values()) {
            ListTag list = tag.m_128437_(type.toString(), 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag entry = list.m_128728_(i);
                String id = entry.m_128461_("id");
                BlockPos position = NbtUtils.m_129239_((CompoundTag)entry.m_128469_("position"));
                LAST_GENERATED.get((Object)type).add(Map.entry(id, position));
            }
        }
        return this;
    }

    @NotNull
    public CompoundTag m_7176_(@NotNull CompoundTag tag) {
        for (Map.Entry<FeatureType, ArrayList<Map.Entry<String, BlockPos>>> e : LAST_GENERATED.entrySet()) {
            ListTag listTag = new ListTag();
            for (Map.Entry<String, BlockPos> entry : e.getValue()) {
                CompoundTag subTag = new CompoundTag();
                subTag.m_128359_("id", entry.getKey());
                subTag.m_128365_("position", (Tag)NbtUtils.m_129224_((BlockPos)entry.getValue()));
                listTag.add((Object)subTag);
            }
            tag.m_128365_(e.getKey().toString(), (Tag)listTag);
        }
        return tag;
    }

    static {
        LAST_GENERATED.put(FeatureType.SURFACE, new ArrayList());
        LAST_GENERATED.put(FeatureType.UNDERGROUND, new ArrayList());
        LAST_GENERATED.put(FeatureType.OCEAN, new ArrayList());
    }

    public static enum FeatureType {
        SURFACE,
        UNDERGROUND,
        OCEAN;

    }
}

