/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.block;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.beachparty.core.block.entity.BeachGoalBlockEntity;
import net.satisfy.beachparty.core.registry.EntityTypeRegistry;
import net.satisfy.beachparty.core.registry.ObjectRegistry;
import net.satisfy.beachparty.core.util.BeachpartyUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TallBeachGoalBlock
extends BaseEntityBlock {
    public static final EnumProperty<Part> PART = EnumProperty.m_61587_((String)"part", Part.class);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final VoxelShape SHAPE_BOTTOM_LEFT = TallBeachGoalBlock.makeBottomLeftShape();
    private static final VoxelShape SHAPE_BOTTOM_RIGHT = TallBeachGoalBlock.makeBottomRightShape();
    private static final VoxelShape SHAPE_TOP_LEFT = TallBeachGoalBlock.makeTopLeftShape();
    private static final VoxelShape SHAPE_TOP_RIGHT = TallBeachGoalBlock.makeTopRightShape();
    public static final Map<Direction, Map<Part, VoxelShape>> SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL.m_122557_().toList()) {
            HashMap<Part, VoxelShape> partShapeMap = new HashMap<Part, VoxelShape>();
            partShapeMap.put(Part.BOTTOM_LEFT, BeachpartyUtil.rotateShape(Direction.NORTH, direction, SHAPE_BOTTOM_LEFT));
            partShapeMap.put(Part.BOTTOM_RIGHT, BeachpartyUtil.rotateShape(Direction.NORTH, direction, SHAPE_BOTTOM_RIGHT));
            partShapeMap.put(Part.TOP_LEFT, BeachpartyUtil.rotateShape(Direction.NORTH, direction, SHAPE_TOP_LEFT));
            partShapeMap.put(Part.TOP_RIGHT, BeachpartyUtil.rotateShape(Direction.NORTH, direction, SHAPE_TOP_RIGHT));
            map.put(direction, partShapeMap);
        }
    });

    public TallBeachGoalBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(PART, (Comparable)((Object)Part.BOTTOM_LEFT))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    private static VoxelShape makeBottomLeftShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.4375, (double)0.125, (double)1.0, (double)0.5625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.5, (double)0.4375, (double)1.0, (double)1.0, (double)0.5625), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    private static VoxelShape makeBottomRightShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.875, (double)0.0, (double)0.4375, (double)1.0, (double)1.0, (double)0.5625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.5, (double)0.4375, (double)0.875, (double)1.0, (double)0.5625), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    private static VoxelShape makeTopLeftShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.4375, (double)1.0, (double)0.875, (double)0.5625), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    private static VoxelShape makeTopRightShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.4375, (double)1.0, (double)0.875, (double)0.5625), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    @NotNull
    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PART, FACING});
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.f_46443_ ? null : BaseEntityBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)EntityTypeRegistry.BEACH_GOAL_BLOCK_ENTITY.get()), BeachGoalBlockEntity::tick);
    }

    public void m_5871_(ItemStack itemStack, BlockGetter world, List<Component> tooltip, TooltipFlag tooltipContext) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.beachparty.canbeplaced").m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)13939843))));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction;
        BlockPos pos = context.m_8083_();
        Level world = context.m_43725_();
        if (!this.canPlaceAt(world, pos, direction = context.m_8125_().m_122424_())) {
            return null;
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_(PART, (Comparable)((Object)Part.BOTTOM_LEFT))).m_61124_((Property)FACING, (Comparable)direction);
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        Player player;
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        world.m_7731_(pos.m_7494_(), (BlockState)((BlockState)this.m_49966_().m_61124_(PART, (Comparable)((Object)Part.TOP_LEFT))).m_61124_((Property)FACING, (Comparable)direction), 3);
        world.m_7731_(pos.m_121945_(direction.m_122427_()), (BlockState)((BlockState)this.m_49966_().m_61124_(PART, (Comparable)((Object)Part.BOTTOM_RIGHT))).m_61124_((Property)FACING, (Comparable)direction), 3);
        world.m_7731_(pos.m_121945_(direction.m_122427_()).m_7494_(), (BlockState)((BlockState)this.m_49966_().m_61124_(PART, (Comparable)((Object)Part.TOP_RIGHT))).m_61124_((Property)FACING, (Comparable)direction), 3);
        world.m_5594_(null, pos, SoundEvents.f_12635_, SoundSource.BLOCKS, 1.0f, 1.0f);
        world.m_5594_(null, pos, SoundEvents.f_271146_, SoundSource.BLOCKS, 1.0f, 1.0f);
        if (placer instanceof Player && !(player = (Player)placer).m_7500_()) {
            stack.m_41774_(1);
        }
    }

    private boolean canPlaceAt(Level world, BlockPos pos, Direction direction) {
        return world.m_8055_(pos).m_247087_() && world.m_8055_(pos.m_7494_()).m_247087_() && world.m_8055_(pos.m_121945_(direction.m_122427_())).m_247087_() && world.m_8055_(pos.m_121945_(direction.m_122427_()).m_7494_()).m_247087_();
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        state.m_60734_();
        newState.m_60734_();
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    private BlockPos getBasePos(BlockState state, BlockPos pos) {
        Part part = (Part)((Object)state.m_61143_(PART));
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        return switch (part) {
            default -> throw new IncompatibleClassChangeError();
            case Part.BOTTOM_LEFT -> pos;
            case Part.TOP_LEFT -> pos.m_7495_();
            case Part.BOTTOM_RIGHT -> pos.m_5484_(direction.m_122428_(), 1);
            case Part.TOP_RIGHT -> pos.m_5484_(direction.m_122428_(), 1).m_7495_();
        };
    }

    private void destroyAdjacentBlocks(Level world, BlockPos basePos) {
        BlockState blockstate = world.m_8055_(basePos);
        Direction facing = (Direction)blockstate.m_61143_((Property)FACING);
        world.m_7471_(basePos, false);
        world.m_7471_(basePos.m_7494_(), false);
        world.m_7471_(basePos.m_5484_(facing.m_122427_(), 1), false);
        world.m_7471_(basePos.m_5484_(facing.m_122427_(), 1).m_7494_(), false);
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        Part part = (Part)((Object)state.m_61143_(PART));
        return SHAPE.get(direction).get((Object)part);
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        state.m_61143_(PART);
        BlockPos basePos = this.getBasePos(world.m_8055_(pos), pos);
        BlockEntity entity = world.m_7702_(basePos);
        assert (entity instanceof BeachGoalBlockEntity);
        BeachGoalBlockEntity bountyBoardBlockEntity = (BeachGoalBlockEntity)entity;
        if (world.m_5776_()) {
            return;
        }
        CompoundTag blockEntityTag = new CompoundTag();
        bountyBoardBlockEntity.m_183515_(blockEntityTag);
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("BlockEntityTag", (Tag)blockEntityTag);
        ItemStack stack = new ItemStack((ItemLike)ObjectRegistry.BEACH_GOAL.get());
        stack.m_41751_(tag);
        world.m_7967_((Entity)new ItemEntity(world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), stack));
        this.destroyAdjacentBlocks(world, basePos);
        super.m_5707_(world, pos, state, player);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        if (blockPos != this.getBasePos(blockState, blockPos)) {
            return null;
        }
        return new BeachGoalBlockEntity(blockPos, blockState);
    }

    public static enum Part implements StringRepresentable
    {
        BOTTOM_LEFT("bottom_left"),
        BOTTOM_RIGHT("bottom_right"),
        TOP_LEFT("top_left"),
        TOP_RIGHT("top_right");

        private final String name;

        private Part(String name) {
            this.name = name;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

