/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.entity;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.satisfy.beachparty.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class BeachBallEntity
extends Mob {
    private static final float BOUNCE_FACTOR = 0.6f;
    private static final float INITIAL_ROLL_SPEED = 2.0f;
    private static final double FRICTION = 0.95;
    private static final float FLOAT_HEIGHT = 0.3f;
    private int waterTicks = 0;

    public BeachBallEntity(EntityType<? extends BeachBallEntity> entityType, Level level) {
        super(entityType, level);
        this.m_20242_(false);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createMobAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 1.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22279_, 0.3);
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_20256_(this.m_20184_().m_82542_(0.95, 1.0, 0.95));
        if (this.m_20069_()) {
            ++this.waterTicks;
            double waterSurfaceY = this.m_20183_().m_123342_() + 1;
            double targetY = waterSurfaceY + (double)0.3f;
            double currentY = this.m_20186_();
            if (this.waterTicks < 10) {
                this.m_20334_(this.m_20184_().f_82479_, -0.05, this.m_20184_().f_82481_);
            } else {
                double error = targetY - currentY;
                double newYVelocity = error * 0.05;
                if (Math.abs(error) < 0.02) {
                    newYVelocity = 0.0;
                }
                this.m_20334_(this.m_20184_().f_82479_, newYVelocity, this.m_20184_().f_82481_);
            }
        } else {
            this.waterTicks = 0;
        }
        if (this.f_19862_) {
            Vector3f bounceVelocity = new Vector3f((float)(-this.m_20184_().f_82479_) * 0.6f, (float)this.m_20184_().f_82480_, (float)(-this.m_20184_().f_82481_) * 0.6f);
            this.m_20334_(bounceVelocity.x, bounceVelocity.y, bounceVelocity.z);
        }
        if (this.m_20184_().m_82556_() > 0.003) {
            this.spawnKickParticles();
        }
    }

    private void spawnKickParticles() {
        SimpleParticleType particle = this.m_7770_() != null && "MissLilitu".equalsIgnoreCase(this.m_7770_().getString()) ? ParticleTypes.f_276452_ : ParticleTypes.f_123797_;
        for (int i = 0; i < 1; ++i) {
            double offsetX = (this.f_19796_.m_188500_() - 0.5) * 0.2;
            double offsetY = (this.f_19796_.m_188500_() - 0.5) * 0.2;
            double offsetZ = (this.f_19796_.m_188500_() - 0.5) * 0.2;
            this.m_9236_().m_7106_((ParticleOptions)particle, this.m_20185_() + offsetX, this.m_20186_() + offsetY, this.m_20189_() + offsetZ, 0.0, 0.0, 0.0);
        }
    }

    public boolean m_6094_() {
        return true;
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        return false;
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    public boolean m_6673_(DamageSource damageSource) {
        return true;
    }

    public void m_7334_(Entity entity) {
        if (entity instanceof Player) {
            float pitch = 0.75f + this.m_9236_().m_213780_().m_188501_() * 0.1f;
            this.m_5496_(SoundEvents.f_11680_, 0.25f, pitch);
            if (this.m_7770_() != null && "Steve".equalsIgnoreCase(this.m_7770_().getString()) && !this.m_9236_().f_46443_) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12506_, this.m_5720_(), 0.25f, 1.0f);
            }
            Vector3f lookDirection = new Vector3f((float)entity.m_20154_().f_82479_, 0.0f, (float)entity.m_20154_().f_82481_).normalize();
            Vector3f pushDirection = lookDirection.mul(2.0f);
            this.m_20334_(pushDirection.x, this.m_20184_().f_82480_, pushDirection.z);
        } else {
            super.m_7334_(entity);
        }
    }

    @NotNull
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (!this.m_9236_().f_46443_) {
            if (player.m_6144_()) {
                this.m_146870_();
                ItemStack beachBallItem = new ItemStack((ItemLike)ObjectRegistry.BEACH_BALL.get());
                if (!player.m_150109_().m_36054_(beachBallItem)) {
                    player.m_36176_(beachBallItem, false);
                }
            } else {
                float pitch = 0.8f + this.m_9236_().m_213780_().m_188501_() * 0.4f;
                if (this.m_7770_() != null) {
                    String name = this.m_7770_().getString();
                    if ("Steve".equalsIgnoreCase(name)) {
                        this.m_5496_(SoundEvents.f_12506_, 0.25f, pitch);
                    } else if ("MissLilitu".equalsIgnoreCase(name)) {
                        this.m_5496_(SoundEvents.f_144141_, 0.25f, pitch);
                    } else {
                        this.m_5496_(SoundEvents.f_11680_, 0.25f, pitch);
                    }
                } else {
                    this.m_5496_(SoundEvents.f_11680_, 0.25f, pitch);
                }
                boolean invertMovement = this.m_7770_() != null && "CR-055".equalsIgnoreCase(this.m_7770_().getString());
                Vector3f lookDirection = new Vector3f(invertMovement ? (float)(-player.m_20154_().f_82479_) : (float)player.m_20154_().f_82479_, 0.0f, invertMovement ? (float)(-player.m_20154_().f_82481_) : (float)player.m_20154_().f_82481_).normalize();
                Vector3f newVelocity = lookDirection.mul(2.0f);
                this.m_20334_(newVelocity.x, 0.25, newVelocity.z);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }
}

