/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.forge.client.renderer.player.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.satisfy.beachparty.client.model.BikiniModel;
import net.satisfy.beachparty.core.item.DyeableBeachpartyArmorItem;
import net.satisfy.beachparty.core.util.BeachpartyIdentifier;
import org.jetbrains.annotations.NotNull;

public class BikiniLayer<T extends LivingEntity, M extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    private final BikiniModel<T> model = new BikiniModel(Minecraft.m_91087_().m_167973_().m_171103_(BikiniModel.LAYER_LOCATION));

    public BikiniLayer(RenderLayerParent<T, M> renderLayerParent) {
        super(renderLayerParent);
    }

    public void render(@NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int light, @NotNull T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity instanceof Player) {
            ItemStack legsStack = entity.m_6844_(EquipmentSlot.LEGS);
            if (legsStack.m_41619_() || !(legsStack.m_41720_() instanceof DyeableBeachpartyArmorItem)) {
                return;
            }
            if (legsStack.m_41782_()) {
                assert (legsStack.m_41783_() != null);
                if (legsStack.m_41783_().m_128441_("Visible") && !legsStack.m_41783_().m_128471_("Visible")) {
                    return;
                }
            }
            int colorInt = ((DyeableBeachpartyArmorItem)legsStack.m_41720_()).m_41121_(legsStack);
            float red = (float)(colorInt >> 16 & 0xFF) / 255.0f;
            float green = (float)(colorInt >> 8 & 0xFF) / 255.0f;
            float blue = (float)(colorInt & 0xFF) / 255.0f;
            this.model.m_6973_((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            poseStack.m_85836_();
            BikiniLayer.renderColoredCutoutModel(this.model, this.getTextureLocation(entity), poseStack, multiBufferSource, light, entity, red, green, blue);
            poseStack.m_85849_();
        }
    }

    @NotNull
    protected ResourceLocation getTextureLocation(@NotNull T entity) {
        return new BeachpartyIdentifier("textures/models/armor/bikini.png");
    }

    private static <T extends LivingEntity, M extends HumanoidModel<T>> void renderColoredCutoutModel(BikiniModel<T> model, ResourceLocation texture, PoseStack poseStack, MultiBufferSource buffer, int light, T entity, float red, float green, float blue) {
        model.m_7695_(poseStack, buffer.m_6299_(RenderType.m_110458_((ResourceLocation)texture)), light, OverlayTexture.f_118083_, red, green, blue, 1.0f);
    }
}

