/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.effect.alcohol;

import dev.architectury.networking.NetworkManager;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.satisfy.brewery.effect.alcohol.AlcoholLevel;
import net.satisfy.brewery.effect.alcohol.AlcoholPlayer;
import net.satisfy.brewery.networking.BreweryNetworking;
import net.satisfy.brewery.registry.MobEffectRegistry;

public class AlcoholManager {
    public static final int BEGIN_TIME = 200;
    public static final int WANDER_AROUND = 100;
    public static final int FALL_DOWN = 140;
    public static final int DRUNK_TIME = 600;

    public static void drinkAlcohol(ServerPlayer serverPlayer) {
        if (serverPlayer instanceof AlcoholPlayer) {
            AlcoholPlayer alcoholPlayer = (AlcoholPlayer)serverPlayer;
            AlcoholLevel alcoholLevel = alcoholPlayer.getAlcohol();
            alcoholLevel.drink();
            serverPlayer.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.DRUNK.get(), 600, alcoholLevel.getDrunkenness() - 1, false, alcoholLevel.isDrunk()));
            if (alcoholLevel.isBlackout() && !serverPlayer.m_21023_((MobEffect)MobEffectRegistry.BLACKOUT.get())) {
                serverPlayer.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.BLACKOUT.get(), 300, 0, false, false));
                serverPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 260, 0, false, false));
            }
            AlcoholManager.syncAlcohol(serverPlayer, alcoholLevel);
        }
    }

    public static void syncAlcohol(ServerPlayer serverPlayer, AlcoholLevel alcoholLevel) {
        FriendlyByteBuf buffer = BreweryNetworking.createPacketBuf();
        buffer.writeInt(alcoholLevel.getDrunkenness());
        buffer.writeInt(alcoholLevel.getImmunity());
        NetworkManager.sendToPlayer((ServerPlayer)serverPlayer, (ResourceLocation)BreweryNetworking.ALCOHOL_SYNC_S2C_ID, (FriendlyByteBuf)buffer);
    }

    public static void movePlayer(LivingEntity livingEntity, Level level) {
        if (!level.f_46443_) {
            for (int i = 0; i < 16; ++i) {
                double g = livingEntity.m_20185_() + (livingEntity.m_217043_().m_188500_() - 0.5) * 16.0;
                double h = Mth.m_14008_((double)(livingEntity.m_20186_() + (double)(livingEntity.m_217043_().m_188503_(16) - 8)), (double)level.m_141937_(), (double)(level.m_141937_() + ((ServerLevel)level).m_143344_() - 1));
                double j = livingEntity.m_20189_() + (livingEntity.m_217043_().m_188500_() - 0.5) * 16.0;
                if (livingEntity.m_20159_()) {
                    livingEntity.m_8127_();
                }
                Vec3 vec3 = livingEntity.m_20182_();
                if (!livingEntity.m_20984_(g, h, j, true)) continue;
                level.m_214171_(GameEvent.f_238175_, vec3, GameEvent.Context.m_223717_((Entity)livingEntity));
            }
        }
    }

    public static Vec3 stagger(Vec3 deltaMovement, RandomSource random) {
        double x = deltaMovement.f_82479_ == 0.0 && deltaMovement.f_82481_ != 0.0 ? 0.1 : deltaMovement.f_82479_;
        double z = deltaMovement.f_82481_ == 0.0 && deltaMovement.f_82479_ != 0.0 ? 0.1 : deltaMovement.f_82481_;
        return deltaMovement.m_82520_(x *= ((double)random.m_188503_(3) - 1.0) / 4.0, 0.0, z *= ((double)random.m_188503_(3) - 1.0) / 4.0);
    }
}

