/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.candlelight.compat.jei.category;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.satisfy.candlelight.client.gui.CookingPanGui;
import net.satisfy.candlelight.client.gui.CookingPotGui;
import net.satisfy.candlelight.compat.jei.CandlelightJEIPlugin;
import net.satisfy.candlelight.recipe.CookingPotRecipe;
import net.satisfy.candlelight.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;

public class CookingPotCategory
implements IRecipeCategory<CookingPotRecipe> {
    public static final RecipeType<CookingPotRecipe> COOKING_POT = RecipeType.create((String)"candlelight", (String)"pot_cooking", CookingPotRecipe.class);
    public static final int WIDTH = 124;
    public static final int HEIGHT = 60;
    public static final int WIDTH_OF = 26;
    public static final int HEIGHT_OF = 13;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable burnIcon;
    private final IDrawableAnimated arrow;
    private final Component localizedName;

    public CookingPotCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(CookingPotGui.BACKGROUND, 26, 13, 124, 60);
        this.arrow = helper.drawableBuilder(CookingPotGui.BACKGROUND, 178, 15, 23, 30).buildAnimated(600, IDrawableAnimated.StartDirection.LEFT, false);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)((Block)ObjectRegistry.COOKING_POT.get()).m_5456_().m_7968_());
        this.burnIcon = helper.createDrawable(CookingPanGui.BACKGROUND, 176, 0, 17, 15);
        this.localizedName = Component.m_237115_((String)"rei.candlelight.cooking_pot_category");
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CookingPotRecipe recipe, IFocusGroup focuses) {
        NonNullList<Ingredient> ingredients = recipe.m_7527_();
        int s = ingredients.size();
        builder.addSlot(RecipeIngredientRole.INPUT, 69, 42).addItemStack(recipe.getContainer());
        for (int row = 0; row < 2; ++row) {
            int current;
            for (int slot = 0; slot < 3 && s - 1 >= (current = slot + row + row * 2); ++slot) {
                CandlelightJEIPlugin.addSlot(builder, 30 + slot * 18 - 26, 17 + row * 18 - 13, (Ingredient)ingredients.get(current));
            }
        }
        assert (Minecraft.m_91087_().f_91073_ != null);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 98, 15).addItemStack(recipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_()));
    }

    public void draw(CookingPotRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.arrow.draw(guiGraphics, 69, 1);
        this.burnIcon.draw(guiGraphics, 98, 43);
    }

    @NotNull
    public RecipeType<CookingPotRecipe> getRecipeType() {
        return COOKING_POT;
    }

    @NotNull
    public Component getTitle() {
        return this.localizedName;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }
}

