/*
 * Decompiled with CFR 0.152.
 */
package com.edge.linden.applied.items;

import appeng.api.config.FuzzyMode;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.ICellWorkbenchItem;
import appeng.api.storage.cells.StorageCell;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.UpgradeInventories;
import appeng.core.AEConfig;
import appeng.core.localization.PlayerMessages;
import appeng.items.contents.CellConfig;
import appeng.items.storage.StorageCellTooltipComponent;
import appeng.util.ConfigInventory;
import appeng.util.Platform;
import com.edge.linden.Raw.AEUniversalTooltips;
import com.edge.linden.Static;
import com.edge.linden.applied.IAEUniversalCell;
import com.edge.linden.applied.me.bigint.IAEBigIntegerCell;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AEBigIntegerCellItem
extends Item
implements IAEBigIntegerCell,
ICellWorkbenchItem {
    private final double idleDrain;

    public AEBigIntegerCellItem(Item.Properties pProperties, double idleDrain) {
        super(pProperties);
        this.idleDrain = idleDrain;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level pLevel, @NotNull List<Component> lines, @NotNull TooltipFlag pIsAdvanced) {
        if (Platform.isClient()) {
            BigInteger used = IAEBigIntegerCell.getUsedBytes(stack);
            lines.add(AEUniversalTooltips.bytesUsed(used, -1L));
            long typesUsed = IAEBigIntegerCell.getUsedTypes(stack);
            lines.add(AEUniversalTooltips.typesUsed(typesUsed, -1L));
        }
    }

    @NotNull
    public Optional<TooltipComponent> m_142422_(@NotNull ItemStack stack) {
        List<GenericStack> show;
        boolean showUpg = AEConfig.instance().isTooltipShowCellUpgrades();
        boolean showCnt = AEConfig.instance().isTooltipShowCellContent();
        List upgrades = Collections.emptyList();
        if (showUpg) {
            ArrayList tmp = new ArrayList();
            this.getUpgrades(stack).forEach(tmp::add);
            upgrades = tmp;
        }
        List content = Collections.emptyList();
        boolean hasMore = false;
        if (showCnt && !(show = IAEUniversalCell.getTooltipShowStacks(stack)).isEmpty()) {
            int limit = 5;
            if (show.size() > 5) {
                content = new ArrayList<GenericStack>(show.subList(0, 5));
                hasMore = true;
            } else {
                content = new ArrayList<GenericStack>(show);
            }
        }
        return Optional.of(new StorageCellTooltipComponent(upgrades, content, hasMore, true));
    }

    @Override
    public double getIdleDrain() {
        return this.idleDrain;
    }

    public IUpgradeInventory getUpgrades(ItemStack is) {
        return UpgradeInventories.forItem((ItemStack)is, (int)2);
    }

    public ConfigInventory getConfigInventory(ItemStack is) {
        return CellConfig.create(key -> true, (ItemStack)is);
    }

    public FuzzyMode getFuzzyMode(ItemStack is) {
        CompoundTag tag = is.m_41784_();
        String fz = tag.m_128461_("FuzzyMode");
        if (fz.isEmpty()) {
            return FuzzyMode.IGNORE_ALL;
        }
        try {
            return FuzzyMode.valueOf((String)fz);
        }
        catch (IllegalArgumentException ex) {
            return FuzzyMode.IGNORE_ALL;
        }
    }

    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
        is.m_41784_().m_128359_("FuzzyMode", fzMode.name());
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        this.disassembleDrive(player.m_21120_(hand), level, player);
        return new InteractionResultHolder(InteractionResult.m_19078_((boolean)level.m_5776_()), (Object)player.m_21120_(hand));
    }

    @NotNull
    public InteractionResult onItemUseFirst(@NotNull ItemStack stack, UseOnContext context) {
        return this.disassembleDrive(stack, context.m_43725_(), context.m_43723_()) ? InteractionResult.m_19078_((boolean)context.m_43725_().m_5776_()) : InteractionResult.PASS;
    }

    public ResourceLocation getRecipeId() {
        return Static.makeId("cells/shapeless/" + Objects.requireNonNull(BuiltInRegistries.f_257033_.m_7981_((Object)this)).m_135815_());
    }

    private boolean disassembleDrive(ItemStack stack, Level level, Player player) {
        if (!player.m_6144_()) {
            return false;
        }
        Recipe recipe = level.m_7465_().m_44043_(this.getRecipeId()).orElse(null);
        if (recipe instanceof CraftingRecipe) {
            CraftingRecipe craftingRecipe = (CraftingRecipe)recipe;
            if (level.m_5776_()) {
                return true;
            }
            Inventory playerInventory = player.m_150109_();
            if (playerInventory.m_36056_() != stack) {
                return false;
            }
            StorageCell inv = StorageCells.getCellInventory((ItemStack)stack, null);
            if (inv == null) {
                return false;
            }
            if (inv.getAvailableStacks().isEmpty()) {
                playerInventory.m_6836_(playerInventory.f_35977_, ItemStack.f_41583_);
                for (Ingredient ingredient : craftingRecipe.m_7527_()) {
                    ItemStack ingredientStack = ingredient.m_43908_()[0].m_41777_();
                    playerInventory.m_150079_(ingredientStack);
                }
                for (ItemStack upgrade : this.getUpgrades(stack)) {
                    playerInventory.m_150079_(upgrade);
                }
            } else {
                player.m_5661_((Component)PlayerMessages.OnlyEmptyCellsCanBeDisassembled.text(), true);
            }
            return true;
        }
        return false;
    }
}

