/*
 * Decompiled with CFR 0.152.
 */
package com.edge.linden.applied.me.bigint;

import appeng.api.stacks.AEKey;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AEBigIntegerCellData
extends SavedData {
    public static final String INV_SAVED_TAG = "inventory";
    private static final String ENTRIES_TAG = "entries";
    private static final String ERROR_ENTRIES_TAG = "error_entries";
    private static final String ENTRY_KEY_TAG = "key";
    private static final String ENTRY_AMOUNT_TAG = "amount";
    public static final String UUID_TAG = "ae_universal_cell_uuid";
    private static final String SAVED_FOLDER_NAME = "ae_universal_cell_data";
    private final Object2ObjectMap<AEKey, BigInteger> storage;
    private final ObjectArrayList<CompoundTag> pendingReadErrors;

    public AEBigIntegerCellData(@NotNull Object2ObjectMap<AEKey, BigInteger> storage) {
        this(storage, (ObjectArrayList<CompoundTag>)new ObjectArrayList());
    }

    private AEBigIntegerCellData(@NotNull Object2ObjectMap<AEKey, BigInteger> storage, @NotNull ObjectArrayList<CompoundTag> pendingReadErrors) {
        this.storage = storage;
        this.storage.defaultReturnValue((Object)BigInteger.ZERO);
        this.pendingReadErrors = pendingReadErrors;
    }

    @NotNull
    public Object2ObjectMap<AEKey, BigInteger> getOriginalStorage() {
        return this.storage;
    }

    @Nullable
    public static AEBigIntegerCellData getCellDataByUUID(@NotNull UUID uuid) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return null;
        }
        AEBigIntegerCellData.ensureSaveDirExists(server);
        String key = AEBigIntegerCellData.makeKey(uuid);
        return (AEBigIntegerCellData)server.m_129783_().m_8895_().m_164858_(AEBigIntegerCellData::load, key);
    }

    @Nullable
    public static AEBigIntegerCellData computeIfAbsentCellDataForItemStack(@NotNull ItemStack itemStack) {
        UUID fresh;
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return null;
        }
        AEBigIntegerCellData.ensureSaveDirExists(server);
        DimensionDataStorage dataStorage = server.m_129783_().m_8895_();
        CompoundTag tag = itemStack.m_41784_();
        if (tag.m_128441_(UUID_TAG)) {
            try {
                UUID existing = UUID.fromString(tag.m_128461_(UUID_TAG));
                AEBigIntegerCellData data = AEBigIntegerCellData.getCellDataByUUID(existing);
                if (data != null) {
                    return data;
                }
            }
            catch (IllegalArgumentException existing) {
                // empty catch block
            }
        }
        while (AEBigIntegerCellData.getCellDataByUUID(fresh = UUID.randomUUID()) != null) {
        }
        tag.m_128359_(UUID_TAG, fresh.toString());
        Object2ObjectOpenHashMap s = new Object2ObjectOpenHashMap();
        s.defaultReturnValue((Object)BigInteger.ZERO);
        AEBigIntegerCellData newData = new AEBigIntegerCellData((Object2ObjectMap<AEKey, BigInteger>)s);
        dataStorage.m_164855_(AEBigIntegerCellData.makeKey(fresh), (SavedData)newData);
        return newData;
    }

    @NotNull
    public CompoundTag m_7176_(@NotNull CompoundTag tag) {
        CompoundTag invTag = new CompoundTag();
        ListTag entriesList = new ListTag();
        for (Object2ObjectMap.Entry e : this.storage.object2ObjectEntrySet()) {
            AEKey key = (AEKey)e.getKey();
            BigInteger amount = (BigInteger)e.getValue();
            if (key == null) {
                System.err.println("[AEUniversalCellData] Skip null key during serialization.");
                continue;
            }
            try {
                CompoundTag entry = new CompoundTag();
                entry.m_128365_(ENTRY_KEY_TAG, (Tag)key.toTagGeneric());
                entry.m_128382_(ENTRY_AMOUNT_TAG, amount.toByteArray());
                entriesList.add((Object)entry);
            }
            catch (Throwable ex) {
                System.err.println("[AEUniversalCellData] Failed to serialize entry: key=" + String.valueOf(key) + ", amount=" + String.valueOf(amount) + " ; cause=" + String.valueOf(ex));
            }
        }
        invTag.m_128365_(ENTRIES_TAG, (Tag)entriesList);
        ListTag errorList = new ListTag();
        for (CompoundTag bad : this.pendingReadErrors) {
            errorList.add((Object)bad.m_6426_());
        }
        invTag.m_128365_(ERROR_ENTRIES_TAG, (Tag)errorList);
        tag.m_128365_(INV_SAVED_TAG, (Tag)invTag);
        return tag;
    }

    public static AEBigIntegerCellData load(CompoundTag tag) {
        Object2ObjectOpenHashMap storage = new Object2ObjectOpenHashMap();
        storage.defaultReturnValue((Object)BigInteger.ZERO);
        ObjectArrayList errorQueue = new ObjectArrayList();
        CompoundTag invTag = tag.m_128469_(INV_SAVED_TAG);
        ListTag entries = invTag.m_128437_(ENTRIES_TAG, 10);
        for (int i = 0; i < entries.size(); ++i) {
            CompoundTag entry = entries.m_128728_(i);
            try {
                CompoundTag keyTag = entry.m_128469_(ENTRY_KEY_TAG);
                AEKey key = AEKey.fromTagGeneric((CompoundTag)keyTag);
                if (key == null) {
                    errorQueue.add((Object)entry.m_6426_());
                    System.err.println("[AEUniversalCellData] Failed to deserialize entry (null key). Entry=" + String.valueOf(entry));
                    continue;
                }
                BigInteger amount = new BigInteger(entry.m_128463_(ENTRY_AMOUNT_TAG));
                AEBigIntegerCellData.addTo((Object2ObjectMap<AEKey, BigInteger>)storage, key, amount);
                continue;
            }
            catch (Throwable ex) {
                errorQueue.add((Object)entry.m_6426_());
                System.err.println("[AEUniversalCellData] Failed to deserialize entry: " + String.valueOf(entry) + " ; cause=" + String.valueOf(ex));
            }
        }
        ListTag oldErrors = invTag.m_128437_(ERROR_ENTRIES_TAG, 10);
        for (int i = 0; i < oldErrors.size(); ++i) {
            CompoundTag badEntry = oldErrors.m_128728_(i);
            boolean recovered = false;
            try {
                CompoundTag keyTag = badEntry.m_128469_(ENTRY_KEY_TAG);
                AEKey key = AEKey.fromTagGeneric((CompoundTag)keyTag);
                if (key != null) {
                    BigInteger amount = new BigInteger(badEntry.m_128463_(ENTRY_AMOUNT_TAG));
                    AEBigIntegerCellData.addTo((Object2ObjectMap<AEKey, BigInteger>)storage, key, amount);
                    recovered = true;
                }
            }
            catch (Throwable ignored) {
                recovered = false;
            }
            if (recovered) {
                System.err.println("[AEUniversalCellData] Recovered previously failed entry: " + String.valueOf(badEntry));
                continue;
            }
            errorQueue.add((Object)badEntry.m_6426_());
        }
        return new AEBigIntegerCellData((Object2ObjectMap<AEKey, BigInteger>)storage, (ObjectArrayList<CompoundTag>)errorQueue);
    }

    private static String makeKey(@NotNull UUID uuid) {
        return "ae_universal_cell_data/" + String.valueOf(uuid);
    }

    private static void ensureSaveDirExists(@NotNull MinecraftServer server) {
        Path dir = server.m_129843_(LevelResource.f_78182_).resolve("data").resolve(SAVED_FOLDER_NAME);
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException e) {
            System.err.println("[AEUniversalCellData] Failed to create save directory: " + String.valueOf(dir) + " : " + String.valueOf(e));
        }
    }

    private static void addTo(Object2ObjectMap<AEKey, BigInteger> map, AEKey key, BigInteger delta) {
        if (delta == null) {
            return;
        }
        if (delta.signum() <= 0) {
            return;
        }
        BigInteger prev = (BigInteger)map.getOrDefault((Object)key, (Object)BigInteger.ZERO);
        BigInteger now = prev.add(delta);
        if (now.signum() == 0) {
            map.remove((Object)key);
        } else {
            map.put((Object)key, (Object)now);
        }
    }
}

