/*
 * Decompiled with CFR 0.152.
 */
package com.edge.linden.applied.me.bigint;

import appeng.api.stacks.GenericStack;
import appeng.api.storage.cells.CellState;
import appeng.api.upgrades.IUpgradeableItem;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public interface IAEBigIntegerCell
extends IUpgradeableItem {
    public static final String CELL_STATE_TAG_NAME = "ae_universal_cell_state";
    public static final String CELL_BYTES_USAGE_BIG_TAG_NAME = "ae_universal_cell_bytes_usage_big";
    public static final String CELL_TYPES_USAGE_TAG_NAME = "ae_universal_cell_types_usage";
    public static final String CELL_SHOW_TOOLTIP_STACKS_TAG_NAME = "ae_universal_cell_show_tooltip_stacks";

    public double getIdleDrain();

    public static BigInteger getUsedBytes(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return BigInteger.ZERO;
        }
        if (tag.m_128425_(CELL_BYTES_USAGE_BIG_TAG_NAME, 7)) {
            byte[] arr = tag.m_128463_(CELL_BYTES_USAGE_BIG_TAG_NAME);
            if (arr.length == 0) {
                return BigInteger.ZERO;
            }
            return new BigInteger(arr);
        }
        return BigInteger.ZERO;
    }

    public static void setUsedBytes(ItemStack stack, BigInteger usedBytes) {
        CompoundTag tag = stack.m_41784_();
        if (usedBytes == null) {
            tag.m_128473_(CELL_BYTES_USAGE_BIG_TAG_NAME);
            return;
        }
        tag.m_128382_(CELL_BYTES_USAGE_BIG_TAG_NAME, usedBytes.toByteArray());
    }

    public static int getUsedTypes(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return 0;
        }
        if (tag.m_128441_(CELL_TYPES_USAGE_TAG_NAME)) {
            return tag.m_128451_(CELL_TYPES_USAGE_TAG_NAME);
        }
        return 0;
    }

    public static void setUsedTypes(ItemStack stack, int usedTypes) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_(CELL_TYPES_USAGE_TAG_NAME, Math.max(0, usedTypes));
    }

    public static CellState getCellState(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return CellState.EMPTY;
        }
        if (!tag.m_128425_(CELL_STATE_TAG_NAME, 8)) {
            return CellState.EMPTY;
        }
        try {
            return CellState.valueOf((String)tag.m_128461_(CELL_STATE_TAG_NAME));
        }
        catch (IllegalArgumentException ex) {
            return CellState.EMPTY;
        }
    }

    public static void setCellState(ItemStack stack, CellState newState) {
        stack.m_41784_().m_128359_(CELL_STATE_TAG_NAME, newState.name());
    }

    public static List<GenericStack> getTooltipShowStacks(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return List.of();
        }
        ListTag list = tag.m_128437_(CELL_SHOW_TOOLTIP_STACKS_TAG_NAME, 10);
        if (list.isEmpty()) {
            return List.of();
        }
        ArrayList<GenericStack> out = new ArrayList<GenericStack>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag entry = list.m_128728_(i);
            GenericStack genericStack = GenericStack.readTag((CompoundTag)entry);
            if (genericStack == null) continue;
            out.add(genericStack);
        }
        return Collections.unmodifiableList(out);
    }

    public static void setTooltipShowStacks(ItemStack stack, List<GenericStack> showStacks) {
        if (showStacks == null || showStacks.isEmpty()) {
            CompoundTag tag = stack.m_41783_();
            if (tag != null) {
                tag.m_128473_(CELL_SHOW_TOOLTIP_STACKS_TAG_NAME);
            }
            return;
        }
        ListTag list = new ListTag();
        for (GenericStack gs : showStacks) {
            if (gs == null) continue;
            list.add((Object)GenericStack.writeTag((GenericStack)gs));
        }
        stack.m_41784_().m_128365_(CELL_SHOW_TOOLTIP_STACKS_TAG_NAME, (Tag)list);
    }
}

