/*
 * Decompiled with CFR 0.152.
 */
package com.edge.linden.botania.entity;

import com.edge.linden.Raw.PacketSpawnEnergizeraFX;
import com.edge.linden.botania.registry.LindenBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zeith.hammerlib.net.IPacket;
import org.zeith.hammerlib.net.Network;
import org.zeith.hammerlib.util.colors.ColorHelper;
import vazkii.botania.api.BotaniaForgeClientCapabilities;
import vazkii.botania.api.block.WandHUD;
import vazkii.botania.api.block_entity.BindableSpecialFlowerBlockEntity;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.client.fx.WispParticleData;

public class Energizera
extends GeneratingFlowerBlockEntity {
    public static final String TAG_SEARCH_COOLDOWN = "searchcooldown";
    public static final String TAG_COOLDOWN = "cooldown";
    public static final String TAG_SOURCE = "source";
    public int searchCooldown;
    public int cooldown;
    public int prevCooldown;
    public Direction lastSuccessfulDir;
    public BlockPos lastSuccessfulPos;
    private final LazyOptional<WandHUD> wandHudCap = LazyOptional.of(() -> new BindableSpecialFlowerBlockEntity.BindableFlowerWandHud((BindableSpecialFlowerBlockEntity)this));

    public Energizera(BlockPos pos, BlockState state) {
        super((BlockEntityType)LindenBlockEntities.ENERGIZERA.get(), pos, state);
    }

    public void tickFlower() {
        RandomSource rng;
        BlockPos pos;
        super.tickFlower();
        if (this.searchCooldown > 0) {
            --this.searchCooldown;
        }
        if (this.cooldown > 0) {
            int reduce = Math.min(60, this.cooldown);
            this.cooldown -= reduce;
            if (!this.f_58857_.f_46443_) {
                this.addMana(reduce);
                this.sync();
            }
            int rgb = this.getColor();
            WispParticleData data = WispParticleData.wisp((float)((float)Math.random() / 6.0f), (float)ColorHelper.getRed((int)rgb), (float)ColorHelper.getGreen((int)rgb), (float)ColorHelper.getBlue((int)rgb), (float)1.0f);
            this.emitParticle((ParticleOptions)data, 0.5 + Math.random() * 0.2 - 0.1, 0.5 + Math.random() * 0.2 - 0.1, 0.5 + Math.random() * 0.2 - 0.1, 0.0, (float)Math.random() / 30.0f, 0.0);
            this.prevCooldown = this.cooldown;
            return;
        }
        if (this.f_58857_.f_46443_ || this.getMana() >= this.getMaxMana() || this.searchCooldown > 0) {
            return;
        }
        int feRate = 20;
        int multiplier = 1000;
        this.searchCooldown += 3;
        if (this.suckEnergy(feRate, multiplier)) {
            return;
        }
        for (int i = 0; !(i >= 12 || this.findStorage(pos = this.f_58858_.m_7918_((rng = this.f_58857_.f_46441_).m_216339_(-4, 4), rng.m_216339_(-2, 2), rng.m_216339_(-4, 4)), feRate) != null && this.suckEnergy(feRate, multiplier)); ++i) {
        }
        if (this.cooldown > 0) {
            --this.cooldown;
        }
    }

    protected boolean suckEnergy(int feRate, int multiplier) {
        IEnergyStorage fe = this.findStorage(null, feRate);
        if (fe == null) {
            return false;
        }
        int canAcceptMana = this.getMaxMana() - this.getMana();
        int canAcceptFE = feRate * canAcceptMana;
        int canTakeFE = fe.extractEnergy(canAcceptFE * multiplier, true);
        canTakeFE -= canTakeFE % feRate;
        int addMana = fe.extractEnergy(canTakeFE, false) / feRate;
        this.cooldown += addMana;
        this.sync();
        if (this.lastSuccessfulPos != null && this.f_58858_ != null) {
            Vec3 start = this.f_58857_.m_8055_(this.lastSuccessfulPos).m_60808_((BlockGetter)this.f_58857_, this.lastSuccessfulPos).m_83215_().m_82338_(this.lastSuccessfulPos).m_82399_();
            Vec3 end = this.f_58857_.m_8055_(this.f_58858_).m_60808_((BlockGetter)this.f_58857_, this.f_58858_).m_83215_().m_82338_(this.f_58858_).m_82399_().m_82520_(0.0, (double)0.2f, 0.0);
            Network.sendToTracking((BlockEntity)this, (IPacket)new PacketSpawnEnergizeraFX(start, end));
        }
        return true;
    }

    public IEnergyStorage findStorage(BlockPos pos, int minEnergy) {
        if (pos == null) {
            pos = this.lastSuccessfulPos;
        }
        if (pos == null || !this.f_58857_.m_46749_(pos)) {
            return null;
        }
        BlockEntity be = this.f_58857_.m_7702_(pos);
        if (be == null) {
            return null;
        }
        IEnergyStorage fe = null;
        if (this.lastSuccessfulDir != null && (fe = (IEnergyStorage)be.getCapability(ForgeCapabilities.ENERGY, this.lastSuccessfulDir).orElse(null)) != null && fe.canExtract() && fe.getEnergyStored() >= minEnergy) {
            this.lastSuccessfulPos = pos;
            return fe;
        }
        this.lastSuccessfulPos = null;
        this.lastSuccessfulDir = null;
        for (Direction dir : Direction.values()) {
            fe = (IEnergyStorage)be.getCapability(ForgeCapabilities.ENERGY, dir).orElse(null);
            if (fe == null || !fe.canExtract() || fe.getEnergyStored() < minEnergy) continue;
            this.lastSuccessfulPos = pos;
            this.lastSuccessfulDir = dir;
            return fe;
        }
        return fe;
    }

    public int getColor() {
        return 15679552;
    }

    public int getMaxMana() {
        return 100000;
    }

    @Nullable
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square((BlockPos)this.f_58858_, (int)4);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == BotaniaForgeClientCapabilities.WAND_HUD) {
            return this.wandHudCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public void writeToPacketNBT(CompoundTag cmp) {
        super.writeToPacketNBT(cmp);
        cmp.m_128405_(TAG_COOLDOWN, this.cooldown);
        cmp.m_128405_(TAG_SEARCH_COOLDOWN, this.searchCooldown);
        if (this.lastSuccessfulPos != null) {
            cmp.m_128365_(TAG_SOURCE, (Tag)NbtUtils.m_129224_((BlockPos)this.lastSuccessfulPos));
        }
    }

    public void readFromPacketNBT(CompoundTag cmp) {
        super.readFromPacketNBT(cmp);
        this.cooldown = cmp.m_128451_(TAG_COOLDOWN);
        this.searchCooldown = cmp.m_128451_(TAG_SEARCH_COOLDOWN);
        this.lastSuccessfulPos = cmp.m_128425_(TAG_SOURCE, 10) ? NbtUtils.m_129239_((CompoundTag)cmp.m_128469_(TAG_SOURCE)) : null;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, Energizera be) {
        be.tickFlower();
    }
}

