/*
 * Decompiled with CFR 0.152.
 */
package com.edge.linden.botania.registry;

import com.edge.linden.generators.procedures.ModRarities;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class LindenItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"linden");
    private static final List<RegisteredItem> REGISTERED_ITEMS = new ArrayList<RegisteredItem>();

    public static RegisteredItem register(String name, Supplier<Item> supplier, boolean addToCreativeTab) {
        RegistryObject reg = ITEMS.register(name, supplier);
        RegisteredItem rItem = new RegisteredItem((RegistryObject<Item>)reg, addToCreativeTab);
        REGISTERED_ITEMS.add(rItem);
        return rItem;
    }

    public static RegisteredItem registerBlockItem(String name, RegistryObject<?> block, boolean addToCreativeTab) {
        return LindenItems.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().m_41497_(ModRarities.BOTANIA)), addToCreativeTab);
    }

    public static RegisteredItem registerBlockItem(String name, RegistryObject<Block> block, BlockItemFactory itemFactory, boolean addToCreativeTab) {
        return LindenItems.register(name, () -> itemFactory.create((Block)block.get(), new Item.Properties().m_41497_(ModRarities.BOTANIA)), addToCreativeTab);
    }

    public static List<RegistryObject<Item>> getItemsForCreativeTab() {
        ArrayList<RegistryObject<Item>> result = new ArrayList<RegistryObject<Item>>();
        for (RegisteredItem r : REGISTERED_ITEMS) {
            if (!r.addToCreativeTab) continue;
            result.add(r.item);
        }
        return result;
    }

    public static void register(IEventBus bus) {
        ITEMS.register(bus);
    }

    public static class RegisteredItem {
        public final RegistryObject<Item> item;
        public final boolean addToCreativeTab;

        public RegisteredItem(RegistryObject<Item> item, boolean addToCreativeTab) {
            this.item = item;
            this.addToCreativeTab = addToCreativeTab;
        }
    }

    @FunctionalInterface
    public static interface BlockItemFactory {
        public BlockItem create(Block var1, Item.Properties var2);
    }
}

