/*
 * Decompiled with CFR 0.152.
 */
package com.edge.linden.client;

import com.edge.linden.Static;
import com.edge.linden.util.ResourceLocationHelper;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.DyeColor;
import vazkii.botania.common.helper.ColorHelper;

public class MiscellaneousModels {
    private static final ResourceLocation asgardSpreaderScaffoldingId = ResourceLocationHelper.prefix("block/asgard_spreader_scaffolding");
    private static final ResourceLocation alfheimSpreaderScaffoldingId = ResourceLocationHelper.prefix("block/alfheim_spreader_scaffolding");
    private static final ResourceLocation muspelheimSpreaderScaffoldingId = ResourceLocationHelper.prefix("block/muspelheim_spreader_scaffolding");
    private static final ResourceLocation nilfheimSpreaderScaffoldingId = ResourceLocationHelper.prefix("block/nilfheim_spreader_scaffolding");
    private static final ResourceLocation asgardSpreaderCoreId = ResourceLocationHelper.prefix("block/asgard_spreader_core");
    private static final ResourceLocation alfheimSpreaderCoreId = ResourceLocationHelper.prefix("block/alfheim_spreader_core");
    private static final ResourceLocation muspelheimSpreaderCoreId = ResourceLocationHelper.prefix("block/muspelheim_spreader_core");
    private static final ResourceLocation nilfheimSpreaderCoreId = ResourceLocationHelper.prefix("block/nilfheim_spreader_core");
    private static final Map<DyeColor, ResourceLocation> spreaderPaddingIds = new EnumMap(ColorHelper.supportedColors().collect(Collectors.toMap(Function.identity(), color -> ResourceLocationHelper.prefix("block/" + color.m_7912_() + "_spreader_padding"))));
    public static final MiscellaneousModels INSTANCE = new MiscellaneousModels();
    private final Map<ResourceLocation, Function<BakedModel, BakedModel>> afterBakeModifiers;
    private final Map<ResourceLocation, Consumer<BakedModel>> modelConsumers;
    public boolean registeredModels = false;
    public BakedModel nilfheimSpreaderCore;
    public BakedModel alfheimSpreaderCore;
    public BakedModel asgardSpreaderCore;
    public BakedModel muspelheimSpreaderCore;
    public BakedModel alfheimSpreaderScaffolding;
    public BakedModel nilfheimSpreaderScaffolding;
    public BakedModel muspelheimSpreaderScaffolding;
    public BakedModel asgardSpreaderScaffolding;
    public final HashMap<DyeColor, BakedModel> spreaderPaddings = new HashMap();

    public void onModelRegister(ResourceManager rm, Consumer<ResourceLocation> consumer) {
        this.modelConsumers.keySet().forEach(consumer);
        MiscellaneousModels.registerTaters(rm, consumer);
        if (!this.registeredModels) {
            this.registeredModels = true;
        }
    }

    private static void registerTaters(ResourceManager rm, Consumer<ResourceLocation> consumer) {
        for (ResourceLocation model : rm.m_214159_("models/tiny_potato", s -> s.m_135815_().endsWith(".json")).keySet()) {
            if (!"linden".equals(model.m_135827_())) continue;
            String path = model.m_135815_();
            path = path.substring("models/".length(), path.length() - ".json".length());
            consumer.accept(new ResourceLocation("linden", path));
        }
    }

    public void onModelBake(ModelBakery loader, Map<ResourceLocation, BakedModel> map) {
        if (!this.registeredModels) {
            Static.LOGGER.error("Additional models failed to register! Aborting baking models to avoid early crashing.");
            return;
        }
        this.afterBakeModifiers.forEach((resourceLocation, afterBakeModifier) -> map.computeIfPresent((ResourceLocation)resourceLocation, (resourceLoc, bakedModel) -> (BakedModel)afterBakeModifier.apply(bakedModel)));
        this.modelConsumers.forEach((resourceLocation, bakedModelConsumer) -> bakedModelConsumer.accept((BakedModel)map.get(resourceLocation)));
    }

    public BakedModel modifyModelAfterbake(BakedModel bakedModel, ResourceLocation id) {
        this.modelConsumers.getOrDefault(id, model -> {}).accept(bakedModel);
        return (BakedModel)this.afterBakeModifiers.getOrDefault(id, Function.identity()).apply(bakedModel);
    }

    private MiscellaneousModels() {
        this.afterBakeModifiers = new HashMap<ResourceLocation, Function<BakedModel, BakedModel>>();
        this.modelConsumers = new HashMap<ResourceLocation, Consumer<BakedModel>>();
        this.modelConsumers.put(asgardSpreaderScaffoldingId, bakedModel -> {
            this.asgardSpreaderScaffolding = bakedModel;
        });
        this.modelConsumers.put(nilfheimSpreaderScaffoldingId, bakedModel -> {
            this.nilfheimSpreaderScaffolding = bakedModel;
        });
        this.modelConsumers.put(alfheimSpreaderScaffoldingId, bakedModel -> {
            this.alfheimSpreaderScaffolding = bakedModel;
        });
        this.modelConsumers.put(muspelheimSpreaderScaffoldingId, bakedModel -> {
            this.muspelheimSpreaderScaffolding = bakedModel;
        });
        this.modelConsumers.put(nilfheimSpreaderCoreId, bakedModel -> {
            this.nilfheimSpreaderCore = bakedModel;
        });
        this.modelConsumers.put(asgardSpreaderCoreId, bakedModel -> {
            this.asgardSpreaderCore = bakedModel;
        });
        this.modelConsumers.put(muspelheimSpreaderCoreId, bakedModel -> {
            this.muspelheimSpreaderCore = bakedModel;
        });
        this.modelConsumers.put(alfheimSpreaderCoreId, bakedModel -> {
            this.alfheimSpreaderCore = bakedModel;
        });
        for (DyeColor color : spreaderPaddingIds.keySet()) {
            this.modelConsumers.put(spreaderPaddingIds.get(color), bakedModel -> this.spreaderPaddings.put(color, (BakedModel)bakedModel));
        }
    }

    private static BakedModel[] getBakedModels(Map<ResourceLocation, Consumer<BakedModel>> consumers, ResourceLocation[] ids) {
        BakedModel[] bakedModels = new BakedModel[ids.length];
        int i = 0;
        while (i < ids.length) {
            int index = i++;
            consumers.put(ids[index], bakedModel -> {
                bakedModels[index] = bakedModel;
            });
        }
        return bakedModels;
    }
}

