/*
 * Decompiled with CFR 0.152.
 */
package com.edge.linden.client.particle.lightning;

import com.edge.linden.client.particle.lightning.BoltCore;
import com.edge.linden.client.particle.lightning.BoltParticleType;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public record Bolt(long seed, int age, float angleMult, int speed, Fractal fractal, Layer inner, Layer outer) implements ParticleOptions
{
    public static final Codec<Bolt> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("seed").forGetter(Bolt::seed), (App)Codec.INT.fieldOf("age").forGetter(Bolt::age), (App)Codec.FLOAT.fieldOf("angle").forGetter(Bolt::angleMult), (App)Codec.INT.fieldOf("speed").forGetter(Bolt::speed), (App)Fractal.CODEC.fieldOf("fractal").forGetter(Bolt::fractal), (App)Layer.CODEC.fieldOf("inner").forGetter(Bolt::inner), (App)Layer.CODEC.fieldOf("outer").forGetter(Bolt::outer)).apply((Applicative)instance, Bolt::new));
    public static final ParticleOptions.Deserializer<Bolt> DESERIALIZER = new ParticleOptions.Deserializer<Bolt>(){

        public Bolt fromCommand(ParticleType<Bolt> p_123733_, StringReader p_123734_) throws CommandSyntaxException {
            MutableComponent msg = Component.m_237113_((String)"Bolt particle deserialization is not supported.");
            throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)msg), (Message)msg);
        }

        public Bolt fromNetwork(ParticleType<Bolt> type, FriendlyByteBuf buf) {
            return new Bolt(buf.readLong(), buf.readInt(), buf.readFloat(), buf.readInt(), Fractal.fromNetwork(buf), Layer.fromNetwork(buf), Layer.fromNetwork(buf));
        }
    };

    public void m_7711_(FriendlyByteBuf buf) {
        buf.writeLong(this.seed);
        buf.writeInt(this.age);
        buf.writeFloat(this.angleMult);
        buf.writeInt(this.speed);
        this.fractal.toNetwork(buf);
        this.inner.toNetwork(buf);
        this.outer.toNetwork(buf);
    }

    public ParticleType<?> m_6012_() {
        return BoltParticleType.TYPE;
    }

    public String m_5942_() {
        return "";
    }

    public record Fractal(int splits, float baseAngle) {
        public static final Codec<Fractal> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("splits").forGetter(Fractal::splits), (App)Codec.FLOAT.fieldOf("angle").forGetter(Fractal::baseAngle)).apply((Applicative)instance, Fractal::new));
        public static final Fractal DEFAULT_FRACTAL = new Fractal();

        public Fractal() {
            this(2, 45.0f);
        }

        public static Fractal fromNetwork(FriendlyByteBuf buf) {
            return new Fractal(buf.readInt(), buf.readFloat());
        }

        public void toNetwork(FriendlyByteBuf buf) {
            buf.writeInt(this.splits);
            buf.writeFloat(this.baseAngle);
        }

        public void apply(BoltCore core) {
            core.defaultFractal(this.splits, this.baseAngle);
        }
    }

    public record Layer(int blendFunc, int color, boolean active) {
        public static final Codec<Layer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("func").forGetter(Layer::blendFunc), (App)Codec.INT.fieldOf("color").forGetter(Layer::color), (App)Codec.BOOL.fieldOf("active").forGetter(Layer::active)).apply((Applicative)instance, Layer::new));
        private static long counter = 0L;

        public Layer {
            ++counter;
        }

        public Layer(boolean active) {
            this(771, counter % 2L == 1L ? 0xFF00FF : 0, active);
        }

        public Layer() {
            this(true);
        }

        public static Layer fromNetwork(FriendlyByteBuf buf) {
            return new Layer(buf.readInt(), buf.readInt(), buf.readBoolean());
        }

        public void toNetwork(FriendlyByteBuf buf) {
            buf.writeInt(this.blendFunc);
            buf.writeFloat((float)this.color);
            buf.writeBoolean(this.active);
        }
    }
}

