/*
 * Decompiled with CFR 0.152.
 */
package com.edge.linden.client.particle.lightning;

import com.edge.linden.Static;
import com.edge.linden.client.particle.lightning.Bolt;
import com.edge.linden.client.particle.lightning.BoltCore;
import com.edge.linden.client.particle.lightning.ThVector3;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.zeith.hammerlib.util.colors.ColorHelper;

public class BoltParticle
extends Particle {
    protected BoltCore main;
    protected Bolt settings;
    private final RenderType renderTypeSmall = RenderType.m_110473_((ResourceLocation)Static.id("textures/particle/p_small.png"));
    private final RenderType renderTypeLarge = RenderType.m_110473_((ResourceLocation)Static.id("textures/particle/p_large.png"));

    protected BoltParticle(ClientLevel level, Vec3 start, Vec3 end, Bolt settings) {
        super(level, start.f_82479_, start.f_82480_, start.f_82481_);
        this.main = new BoltCore(start.f_82479_, start.f_82480_, start.f_82481_, end.f_82479_, end.f_82480_, end.f_82481_, settings.seed(), settings.age(), settings.angleMult(), settings.speed());
        this.settings = settings;
        settings.fractal().apply(this.main);
        this.main.finalizeBolt();
        this.setupFromMain();
        AABB bb = this.main.getBoundingBox();
        this.f_107221_ = (float)Math.max(bb.m_82362_(), bb.m_82385_()) + 2.0f;
        this.f_107222_ = (float)bb.m_82376_() + 2.0f;
    }

    public void finalizeBolt() {
        this.main.finalizeBolt();
        this.setupFromMain();
        Minecraft.m_91087_().f_91061_.m_107344_((Particle)this);
    }

    private void setupFromMain() {
        this.f_107225_ = this.main.particleMaxAge;
        this.m_107264_(this.main.start.x, this.main.start.y, this.main.start.z);
    }

    public boolean shouldCull() {
        return true;
    }

    public AABB m_107277_() {
        if (this.main != null) {
            AABB bb = this.main.getBoundingBox();
            this.f_107221_ = (float)Math.max(bb.m_82362_(), bb.m_82385_()) + 2.0f;
            this.f_107222_ = (float)bb.m_82376_() + 2.0f;
            return this.main.getBoundingBox().m_82377_((double)this.f_107221_, (double)this.f_107222_, (double)this.f_107221_);
        }
        return super.m_107277_();
    }

    public void m_5989_() {
        this.main.onUpdate();
        if (this.main.particleAge >= this.main.particleMaxAge) {
            this.m_107274_();
        }
    }

    public void m_5744_(VertexConsumer b, Camera cam, float partialframe) {
        VertexConsumer vertexconsumer;
        int rgb;
        MultiBufferSource.BufferSource tessellator = Minecraft.m_91087_().m_91269_().m_110104_();
        Bolt.Layer aura = this.settings.outer();
        Bolt.Layer core = this.settings.inner();
        RenderSystem.depthMask((boolean)false);
        if (aura.active()) {
            RenderSystem.blendFunc((int)770, (int)aura.blendFunc());
            rgb = aura.color();
            this.f_107227_ = ColorHelper.getRed((int)rgb);
            this.f_107228_ = ColorHelper.getGreen((int)rgb);
            this.f_107229_ = ColorHelper.getBlue((int)rgb);
            vertexconsumer = tessellator.m_6299_(this.renderTypeLarge);
            this.renderBolt(vertexconsumer, cam, partialframe, 0);
            tessellator.m_109911_();
        }
        if (core.active()) {
            RenderSystem.blendFunc((int)770, (int)core.blendFunc());
            rgb = core.color();
            this.f_107227_ = ColorHelper.getRed((int)rgb);
            this.f_107228_ = ColorHelper.getGreen((int)rgb);
            this.f_107229_ = ColorHelper.getBlue((int)rgb);
            vertexconsumer = tessellator.m_6299_(this.renderTypeSmall);
            this.renderBolt(vertexconsumer, cam, partialframe, 1);
            tessellator.m_109911_();
        }
        RenderSystem.defaultBlendFunc();
        RenderSystem.depthMask((boolean)true);
    }

    public void renderBolt(VertexConsumer b, Camera cam, float partialframe, int pass) {
        Vec3 cp = cam.m_90583_();
        float boltage = this.main.particleAge >= 0 ? (float)this.main.particleAge / (float)this.main.particleMaxAge : 0.0f;
        float mainalpha = 1.0f;
        mainalpha = pass == 0 ? (mainalpha - boltage) * 0.4f : (mainalpha -= boltage * 0.5f);
        int renderlength = (int)(((float)this.main.particleAge + partialframe + (float)((int)(this.main.length * 3.0f))) / (float)((int)(this.main.length * 3.0f)) * (float)this.main.numsegments0);
        if (renderlength >= this.main.numsegments0) {
            float progress = 1.0f - ((float)this.main.particleAge + partialframe) / (float)this.main.particleMaxAge;
            mainalpha *= (progress *= 0.75f);
        }
        double interpPosX = cp.f_82479_;
        double interpPosY = cp.f_82480_;
        double interpPosZ = cp.f_82481_;
        int fullBright = 0xF000F0;
        ThVector3 cptv = BoltParticle.getActiveViewVector(cam);
        for (BoltCore.Segment seg : this.main.segments) {
            if (seg.segmentno > renderlength) break;
            float width = 0.03f * (BoltParticle.getRelativeViewVector(seg.startpoint.point, cam).length() / 5.0f + 1.0f) * (1.0f + seg.light) * 0.5f;
            ThVector3 diff1 = ThVector3.crossProduct(cptv, seg.prevdiff).scale(width / seg.sinprev);
            ThVector3 diff2 = ThVector3.crossProduct(cptv, seg.nextdiff).scale(width / seg.sinnext);
            ThVector3 startvec = seg.startpoint.point;
            ThVector3 endvec = seg.endpoint.point;
            float rx1 = (float)((double)startvec.x - interpPosX);
            float ry1 = (float)((double)startvec.y - interpPosY);
            float rz1 = (float)((double)startvec.z - interpPosZ);
            float rx2 = (float)((double)endvec.x - interpPosX);
            float ry2 = (float)((double)endvec.y - interpPosY);
            float rz2 = (float)((double)endvec.z - interpPosZ);
            BoltParticle.vertex(b, null, rx2 - diff2.x, ry2 - diff2.y, rz2 - diff2.z, this.f_107227_, this.f_107228_, this.f_107229_, mainalpha * seg.light, 0.5f, 0.0f, OverlayTexture.f_118083_, fullBright, 0.0f, 1.0f, 0.0f);
            BoltParticle.vertex(b, null, rx1 - diff1.x, ry1 - diff1.y, rz1 - diff1.z, this.f_107227_, this.f_107228_, this.f_107229_, mainalpha * seg.light, 0.5f, 0.0f, OverlayTexture.f_118083_, fullBright, 0.0f, 1.0f, 0.0f);
            BoltParticle.vertex(b, null, rx1 + diff1.x, ry1 + diff1.y, rz1 + diff1.z, this.f_107227_, this.f_107228_, this.f_107229_, mainalpha * seg.light, 0.5f, 1.0f, OverlayTexture.f_118083_, fullBright, 0.0f, 1.0f, 0.0f);
            BoltParticle.vertex(b, null, rx2 + diff2.x, ry2 + diff2.y, rz2 + diff2.z, this.f_107227_, this.f_107228_, this.f_107229_, mainalpha * seg.light, 0.5f, 1.0f, OverlayTexture.f_118083_, fullBright, 0.0f, 1.0f, 0.0f);
        }
    }

    static ThVector3 getActiveViewVector(Camera cam) {
        Vector3f lv = cam.m_253058_();
        return new ThVector3(lv.x(), lv.y(), lv.z());
    }

    static void vertex(VertexConsumer vc, PoseStack.Pose pose, double x, double y, double z, float r, float g, float b, float a, float u, float v, int overlay, int uv2, float nx, float ny, float nz) {
        vc.m_5483_((double)((float)x), (double)((float)y), (double)((float)z));
        vc.m_85950_(r, g, b, a);
        vc.m_7421_(u, v);
        vc.m_86008_(overlay);
        vc.m_85969_(uv2);
        vc.m_5601_(nx, ny, nz);
        vc.m_5752_();
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107433_;
    }

    private static ThVector3 getRelativeViewVector(ThVector3 pos, Camera cam) {
        Vec3 r = cam.m_90583_();
        return new ThVector3(r.f_82479_ - (double)pos.x, r.f_82480_ - (double)pos.y, r.f_82481_ - (double)pos.z);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<Bolt> {
        @Nullable
        public Particle createParticle(Bolt options, ClientLevel level, double x, double y, double z, double tx, double ty, double tz) {
            return new BoltParticle(level, new Vec3(x, y, z), new Vec3(tx, ty, tz), options);
        }
    }
}

