/*
 * Decompiled with CFR 0.152.
 */
package com.edge.linden.client.particle.lightning;

import com.edge.linden.client.particle.lightning.ThMat4;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class ThVector3 {
    public float x;
    public float y;
    public float z;

    public ThVector3(double x, double y, double z) {
        this.x = (float)x;
        this.y = (float)y;
        this.z = (float)z;
    }

    public ThVector3(Vec3i pos) {
        this.x = (float)pos.m_123341_() + 0.5f;
        this.y = (float)pos.m_123342_() + 0.5f;
        this.z = (float)pos.m_123343_() + 0.5f;
    }

    public ThVector3(Entity entity) {
        this(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
    }

    public ThVector3 add(ThVector3 vec) {
        this.x += vec.x;
        this.y += vec.y;
        this.z += vec.z;
        return this;
    }

    public ThVector3 sub(ThVector3 vec) {
        this.x -= vec.x;
        this.y -= vec.y;
        this.z -= vec.z;
        return this;
    }

    public ThVector3 scale(float scale) {
        this.x *= scale;
        this.y *= scale;
        this.z *= scale;
        return this;
    }

    public ThVector3 scale(float scalex, float scaley, float scalez) {
        this.x *= scalex;
        this.y *= scaley;
        this.z *= scalez;
        return this;
    }

    public ThVector3 normalize() {
        float length = this.length();
        this.x /= length;
        this.y /= length;
        this.z /= length;
        return this;
    }

    public float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public float lengthPow2() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public ThVector3 copy() {
        return new ThVector3(this.x, this.y, this.z);
    }

    public static ThVector3 crossProduct(ThVector3 vec1, ThVector3 vec2) {
        return new ThVector3(vec1.y * vec2.z - vec1.z * vec2.y, vec1.z * vec2.x - vec1.x * vec2.z, vec1.x * vec2.y - vec1.y * vec2.x);
    }

    public static ThVector3 xCrossProduct(ThVector3 vec) {
        return new ThVector3(0.0, vec.z, -vec.y);
    }

    public static ThVector3 zCrossProduct(ThVector3 vec) {
        return new ThVector3(-vec.y, vec.x, 0.0);
    }

    public static float dotProduct(ThVector3 vec1, ThVector3 vec2) {
        return vec1.x * vec2.x + vec1.y * vec2.y + vec1.z * vec2.z;
    }

    public static float angle(ThVector3 vec1, ThVector3 vec2) {
        return ThVector3.anglePreNorm(vec1.copy().normalize(), vec2.copy().normalize());
    }

    public static float anglePreNorm(ThVector3 vec1, ThVector3 vec2) {
        return (float)Math.acos(ThVector3.dotProduct(vec1, vec2));
    }

    public ThVector3 rotate(float angle, ThVector3 axis) {
        return ThMat4.rotationMat(angle, axis).translate(this);
    }

    public String toString() {
        return "[" + this.x + "," + this.y + "," + this.z + "]";
    }

    public Vec3 toVec3D() {
        return new Vec3((double)this.x, (double)this.y, (double)this.z);
    }

    public static ThVector3 getPerpendicular(ThVector3 vec) {
        if (vec.z == 0.0f) {
            return ThVector3.zCrossProduct(vec);
        }
        return ThVector3.xCrossProduct(vec);
    }

    public boolean isZero() {
        return this.x == 0.0f && this.y == 0.0f && this.z == 0.0f;
    }
}

