/*
 * Decompiled with CFR 0.152.
 */
package com.edge.linden.generators.oregen;

import com.edge.linden.generators.quantumgens.GeneratorsRegistry;
import com.edge.linden.registry.ModBlockEntities;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Containers;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class OreGeneratorBlockEntity
extends BlockEntity
implements WorldlyContainer {
    private ItemStack buffer = ItemStack.f_41583_;
    private final ModEnergyStorage energyStorage = new ModEnergyStorage(100000000, 1000000);
    private LazyOptional<ModEnergyStorage> energyStorageOptional = LazyOptional.of(() -> this.energyStorage);
    private final List<ItemStack> ores = new ArrayList<ItemStack>();
    private int tickCounter = 0;
    private final int baseTicksPerOre = 6;
    private final int baseOresPerTick = 32;
    private final int energyPerOre = 50000;
    private int upgradeLevel = 0;
    private final int maxUpgradeLevel = 5;

    public OreGeneratorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.ORE_GENERATOR_BLOCK_ENTITY.get(), pos, state);
        this.reloadOres();
    }

    public void reloadOres() {
        this.ores.clear();
        ForgeRegistries.ITEMS.tags().getTag(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "ores"))).forEach(item -> {
            ResourceLocation id = ForgeRegistries.ITEMS.getKey(item);
            if (id != null && !id.m_135827_().equals("industrialupgrade")) {
                this.ores.add(new ItemStack((ItemLike)item));
            }
        });
    }

    public void tickServer() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        ++this.tickCounter;
        if (this.ores.isEmpty()) {
            return;
        }
        if (this.tickCounter >= this.getEffectiveTicksPerOre()) {
            this.tickCounter = 0;
            int toGenerate = this.getEffectiveOresPerTick();
            for (int i = 0; i < toGenerate && this.energyStorage.getEnergyStored() >= 50000; ++i) {
                ItemStack ore = this.ores.get(this.f_58857_.f_46441_.m_188503_(this.ores.size())).m_41777_();
                ore.m_41764_(1);
                if (this.buffer.m_41619_()) {
                    this.buffer = ore.m_41777_();
                    this.energyStorage.extractEnergy(50000, false);
                    continue;
                }
                if (!ItemStack.m_150942_((ItemStack)this.buffer, (ItemStack)ore) || this.buffer.m_41613_() >= this.buffer.m_41741_()) break;
                this.buffer.m_41769_(1);
                this.energyStorage.extractEnergy(50000, false);
            }
        }
        this.tryExportItem();
    }

    private void tryExportItem() {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.buffer.m_41619_()) {
            return;
        }
        int toExportCount = Math.min(64, this.buffer.m_41613_());
        ItemStack toExport = this.buffer.m_41777_();
        toExport.m_41764_(toExportCount);
        for (Direction direction : Direction.values()) {
            LazyOptional cap;
            if (toExport.m_41619_()) break;
            BlockPos neighborPos = this.f_58858_.m_121945_(direction);
            BlockEntity neighbor = this.f_58857_.m_7702_(neighborPos);
            if (neighbor == null || !(cap = neighbor.getCapability(ForgeCapabilities.ITEM_HANDLER, direction.m_122424_())).isPresent()) continue;
            IItemHandler neighborInv = (IItemHandler)cap.orElse(null);
            for (int slot = 0; slot < neighborInv.getSlots() && !toExport.m_41619_(); ++slot) {
                ItemStack remaining = neighborInv.insertItem(slot, toExport, false);
                int inserted = toExport.m_41613_() - remaining.m_41613_();
                if (inserted <= 0) continue;
                this.buffer.m_41774_(inserted);
                toExport = remaining;
            }
        }
    }

    public void incrementUpgradeLevel() {
        if (this.upgradeLevel < 5) {
            ++this.upgradeLevel;
        }
    }

    public int getUpgradeLevel() {
        return this.upgradeLevel;
    }

    public void setUpgradeLevel(int level) {
        this.upgradeLevel = Math.max(0, Math.min(level, 5));
    }

    public int getMaxUpgradeLevel() {
        return 5;
    }

    public int getEffectiveTicksPerOre() {
        return Math.max(1, 6 - this.upgradeLevel);
    }

    public int getEffectiveOresPerTick() {
        return 32 + this.upgradeLevel;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyStorageOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.energyStorageOptional = LazyOptional.of(() -> this.energyStorage);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.energyStorageOptional.invalidate();
    }

    public void dropItems() {
        if (this.f_58857_ == null) {
            return;
        }
        if (!this.buffer.m_41619_()) {
            Containers.m_18992_((Level)this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (ItemStack)this.buffer);
            this.buffer = ItemStack.f_41583_;
        }
        if (this.upgradeLevel > 0 && GeneratorsRegistry.UPGRADE_ITEM.item.isPresent()) {
            ItemStack upgradeStack = new ItemStack((ItemLike)GeneratorsRegistry.UPGRADE_ITEM.item.get(), this.upgradeLevel);
            ItemEntity upgradeDrop = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, upgradeStack);
            this.f_58857_.m_7967_((Entity)upgradeDrop);
        }
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        CompoundTag bufferTag = new CompoundTag();
        this.buffer.m_41739_(bufferTag);
        nbt.m_128365_("buffer", (Tag)bufferTag);
        nbt.m_128405_("energy", this.energyStorage.getEnergyStored());
        nbt.m_128405_("tickCounter", this.tickCounter);
        nbt.m_128405_("upgradeLevel", this.upgradeLevel);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.buffer = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("buffer"));
        this.energyStorage.setEnergy(nbt.m_128451_("energy"));
        this.tickCounter = nbt.m_128451_("tickCounter");
        this.upgradeLevel = nbt.m_128451_("upgradeLevel");
    }

    public void setEnergy(int energy) {
        this.energyStorage.setEnergy(energy);
    }

    public int[] m_7071_(Direction side) {
        return new int[0];
    }

    public boolean m_7155_(int index, ItemStack stack, Direction direction) {
        return false;
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return false;
    }

    public int m_6643_() {
        return 0;
    }

    public boolean m_7983_() {
        return this.buffer.m_41619_();
    }

    public ItemStack m_8020_(int slot) {
        return ItemStack.f_41583_;
    }

    public ItemStack m_7407_(int slot, int count) {
        return ItemStack.f_41583_;
    }

    public ItemStack m_8016_(int slot) {
        return ItemStack.f_41583_;
    }

    public void m_6836_(int slot, ItemStack stack) {
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public void m_6211_() {
        this.buffer = ItemStack.f_41583_;
    }

    public static class ModEnergyStorage
    extends EnergyStorage {
        public ModEnergyStorage(int capacity, int maxTransfer) {
            super(capacity, maxTransfer);
        }

        public void setEnergy(int energy) {
            this.energy = Math.min(energy, this.getMaxEnergyStored());
        }
    }
}

