/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.merequester.terminal;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.menu.implementations.MenuTypeBuilder;
import com.almostreliable.merequester.platform.Platform;
import com.almostreliable.merequester.requester.RequesterBlockEntity;
import com.almostreliable.merequester.requester.abstraction.AbstractRequesterMenu;
import com.almostreliable.merequester.requester.abstraction.RequestTracker;
import com.almostreliable.merequester.terminal.RequesterTerminalPart;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;

public class RequesterTerminalMenu
extends AbstractRequesterMenu {
    public static final MenuType<RequesterTerminalMenu> TYPE = MenuTypeBuilder.create(RequesterTerminalMenu::new, RequesterTerminalPart.class).build("requester_terminal");
    private final Long2ObjectOpenHashMap<RequestTracker> byId = new Long2ObjectOpenHashMap();
    private final Map<RequesterBlockEntity, RequestTracker> byRequester = new IdentityHashMap<RequesterBlockEntity, RequestTracker>();

    protected RequesterTerminalMenu(MenuType<?> menuType, int id, Inventory playerInventory, Object host) {
        super(menuType, id, playerInventory, host);
    }

    public void m_38946_() {
        if (this.isClientSide()) {
            return;
        }
        super.m_38946_();
        IGrid grid = this.getGrid();
        if (grid == null) {
            return;
        }
        VisitorState state = this.visitRequesters(grid);
        if (state.forceFullUpdate || state.total != this.byRequester.size()) {
            this.sendFullUpdate(grid);
        } else {
            this.sendPartialUpdate();
        }
    }

    protected ItemStack transferStackToMenu(ItemStack stack) {
        List<RequesterBlockEntity> requesters = this.byRequester.keySet().stream().sorted(Comparator.comparingLong(RequesterBlockEntity::getSortValue)).toList();
        for (RequesterBlockEntity requester : requesters) {
            int targetSlot = requester.getRequests().firstAvailableIndex();
            if (targetSlot == -1) continue;
            this.byRequester.get(requester).getServer().insertItem(targetSlot, stack, false);
            return stack;
        }
        return stack;
    }

    @Override
    protected void sendFullUpdate(@Nullable IGrid grid) {
        assert (grid != null);
        this.byId.clear();
        this.byRequester.clear();
        Platform.sendClearData(this.getPlayer());
        for (RequesterBlockEntity requester : grid.getActiveMachines(RequesterBlockEntity.class)) {
            this.byRequester.put(requester, this.createTracker(requester));
        }
        for (RequestTracker requestTracker : this.byRequester.values()) {
            this.byId.put(requestTracker.getId(), (Object)requestTracker);
            this.syncRequestTrackerFull(requestTracker);
        }
    }

    @Override
    protected void sendPartialUpdate() {
        for (RequestTracker requestTracker : this.byRequester.values()) {
            this.syncRequestTrackerPartial(requestTracker);
        }
    }

    @Override
    @Nullable
    protected RequestTracker getRequestTracker(long id) {
        return (RequestTracker)this.byId.get(id);
    }

    private VisitorState visitRequesters(IGrid grid) {
        VisitorState state = new VisitorState();
        for (RequesterBlockEntity requester : grid.getActiveMachines(RequesterBlockEntity.class)) {
            RequestTracker requestTracker = this.byRequester.get(requester);
            if (requestTracker == null || !requestTracker.getName().equals(requester.getTerminalName().getString())) {
                state.forceFullUpdate = true;
                return state;
            }
            ++state.total;
        }
        return state;
    }

    @Nullable
    private IGrid getGrid() {
        IGridNode agn;
        IActionHost host = this.getActionHost();
        if (host != null && (agn = host.getActionableNode()) != null && agn.isActive()) {
            return agn.getGrid();
        }
        return null;
    }

    private static class VisitorState {
        private int total;
        private boolean forceFullUpdate;

        private VisitorState() {
        }
    }
}

