/*
 * Decompiled with CFR 0.152.
 */
package com.powerutils;

import com.denfop.datagen.blocktags.BlockTagsProvider;
import com.denfop.dataregistry.DataBlockEntity;
import com.denfop.dataregistry.DataSimpleItem;
import com.powerutils.BlockPowerConverter;
import com.powerutils.PUItemBase;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod(value="powerutils")
public class PowerUtils {
    private static PowerUtils instance;
    private final FMLJavaModLoadingContext context = FMLJavaModLoadingContext.get();
    public static DataBlockEntity<BlockPowerConverter> itemPowerConverter;
    public static DataSimpleItem<PUItemBase, ResourceLocation> module_ic;
    public static DataSimpleItem<PUItemBase, ResourceLocation> module_fe;
    public static DataSimpleItem<PUItemBase, ResourceLocation> module_qe;
    public static DeferredRegister<Item> ITEMS;
    public static DeferredRegister<Block> BLOCKS;
    public static DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES;

    public PowerUtils() {
        instance = this;
        MinecraftForge.EVENT_BUS.register((Object)this);
        ITEMS.register(this.context.getModEventBus());
        BLOCKS.register(this.context.getModEventBus());
        BLOCK_ENTITIES.register(this.context.getModEventBus());
        this.context.getModEventBus().addListener(this::gatherData);
        itemPowerConverter = new DataBlockEntity(BlockPowerConverter.class, "powerutils", BLOCKS, BLOCK_ENTITIES, ITEMS);
        module_ic = new DataSimpleItem(new ResourceLocation("", "module_ic"), () -> new PUItemBase("module_ic"), "powerutils", ITEMS);
        module_fe = new DataSimpleItem(new ResourceLocation("", "module_fe"), () -> new PUItemBase("module_fe"), "powerutils", ITEMS);
        module_qe = new DataSimpleItem(new ResourceLocation("", "module_qe"), () -> new PUItemBase("module_qe"), "powerutils", ITEMS);
    }

    @SubscribeEvent
    public void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput packOutput = gen.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        BlockTagsProvider blockTags = new BlockTagsProvider(packOutput, lookupProvider, "powerutils", existingFileHelper);
        gen.addProvider(event.includeServer(), (DataProvider)blockTags);
    }

    static {
        ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"powerutils");
        BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"powerutils");
        BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"powerutils");
    }
}

