/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.hurts.sskirillss.relics.client.particles.BasicColoredParticleConstructor;
import it.hurts.sskirillss.relics.init.ParticleRegistry;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.registries.ForgeRegistries;

public class BasicColoredParticleOptions
implements ParticleOptions {
    private final BasicColoredParticleConstructor data;
    public static final Codec<BasicColoredParticleOptions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("color").forGetter(options -> options.getData().getColor().getRGB()), (App)Codec.FLOAT.fieldOf("diameter").forGetter(options -> Float.valueOf(options.getData().getDiameter())), (App)Codec.INT.fieldOf("lifetime").forGetter(options -> options.getData().getLifetime()), (App)Codec.FLOAT.fieldOf("roll").forGetter(options -> Float.valueOf(options.getData().getRoll()))).apply((Applicative)instance, BasicColoredParticleOptions::new));
    public static final ParticleOptions.Deserializer<BasicColoredParticleOptions> DESERIALIZER = new ParticleOptions.Deserializer<BasicColoredParticleOptions>(){

        @Nonnull
        public BasicColoredParticleOptions fromCommand(@Nonnull ParticleType<BasicColoredParticleOptions> type, @Nonnull StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            int color = reader.readInt();
            reader.expect(' ');
            float diameter = reader.readFloat();
            reader.expect(' ');
            int lifetime = reader.readInt();
            reader.expect(' ');
            float roll = reader.readFloat();
            return new BasicColoredParticleOptions(color, diameter, lifetime, roll);
        }

        public BasicColoredParticleOptions fromNetwork(@Nonnull ParticleType<BasicColoredParticleOptions> type, FriendlyByteBuf buf) {
            int color = buf.readInt();
            float diameter = buf.readFloat();
            int lifetime = buf.readInt();
            float roll = buf.readFloat();
            return new BasicColoredParticleOptions(color, diameter, lifetime, roll);
        }
    };

    private BasicColoredParticleOptions(int color, float diameter, int lifetime, float roll) {
        this.data = BasicColoredParticleConstructor.builder().color(color).diameter(diameter).lifetime(lifetime).roll(roll).build();
    }

    public BasicColoredParticleOptions(BasicColoredParticleConstructor data) {
        this.data = data;
    }

    @Nonnull
    public ParticleType<BasicColoredParticleOptions> m_6012_() {
        return (ParticleType)ParticleRegistry.BASIC_COLORED.get();
    }

    public void m_7711_(FriendlyByteBuf buf) {
        buf.writeInt(this.data.getColor().getRGB());
        buf.writeFloat(this.data.getDiameter());
        buf.writeInt(this.data.getLifetime());
        buf.writeFloat(this.data.getRoll());
    }

    @Nonnull
    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %d %.2f %d %.2f", ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()), this.data.getColor().getRGB(), Float.valueOf(this.data.getDiameter()), this.data.getLifetime(), Float.valueOf(this.data.getRoll()));
    }

    public BasicColoredParticleConstructor getData() {
        return this.data;
    }
}

