/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics;

import it.hurts.sskirillss.relics.init.EffectRegistry;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.SlotContext;

public class SpatialSignItem
extends RelicItem {
    public static final String TAG_POSITION = "pos";
    public static final String TAG_TIME = "time";
    public static final String TAG_WORLD = "world";

    @Override
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder("seal").stat(StatData.builder(TAG_TIME).initialValue(2.0, 4.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.25).formatValue(value -> MathUtils.round(value, 1)).build()).build()).build()).leveling(new LevelingData(100, 10, 200)).loot(LootData.builder().entry(LootCollections.ANTHROPOGENIC).build()).build();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        if (NBTUtils.getList(stack, TAG_POSITION, String.class).size() < 2 || worldIn.m_5776_()) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (NBTUtils.getInt(stack, TAG_TIME, 0) > 0) {
            NBTUtils.setInt(stack, TAG_TIME, 0);
        } else {
            NBTUtils.setInt(stack, TAG_TIME, (int)Math.round(this.getAbilityValue(stack, "seal", TAG_TIME)));
            worldIn.m_5594_(null, playerIn.m_20183_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 1.0f, 2.0f);
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!(entityIn instanceof Player)) {
            return;
        }
        Player player = (Player)entityIn;
        RandomSource random = worldIn.m_213780_();
        int time = NBTUtils.getInt(stack, TAG_TIME, -1);
        List<String> positions = NBTUtils.getList(stack, TAG_POSITION, String.class);
        if (time >= 0) {
            if (player.m_20159_()) {
                player.m_8127_();
            }
            if (player.f_19797_ % 20 == 0 && !worldIn.m_5776_()) {
                NBTUtils.setInt(stack, TAG_TIME, --time);
                this.spreadExperience((LivingEntity)player, stack, 1);
            }
            if (time <= 0) {
                worldIn.m_5594_(null, player.m_20183_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 1.0f, 0.5f);
                player.m_36335_().m_41524_((Item)this, (int)(Math.ceil(this.getAbilityValue(stack, "seal", TAG_TIME)) * 20.0));
                NBTUtils.setInt(stack, TAG_TIME, -1);
                return;
            }
            if (!positions.isEmpty()) {
                Vec3 target = NBTUtils.parsePosition(positions.get(positions.size() - 1));
                double distance = player.m_20182_().m_82554_(target);
                if (distance > 2.0) {
                    if (distance > 64.0) {
                        NBTUtils.setInt(stack, TAG_TIME, 0);
                        NBTUtils.setList(stack, TAG_POSITION, new ArrayList());
                    }
                    for (int i = 0; i < 10; ++i) {
                        worldIn.m_7106_(ParticleUtils.constructSimpleSpark(new Color(255 - random.m_188503_(100), 0, 255 - random.m_188503_(50)), 0.1f + random.m_188501_() * 0.25f, 100, 0.96f), player.m_20185_(), player.m_20186_() + (double)(random.m_188501_() * player.m_20206_()), player.m_20189_(), 0.0, (double)(random.m_188501_() * 0.1f), 0.0);
                    }
                    player.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.VANISHING.get(), 5, 0, false, false));
                    player.m_20256_(target.m_82520_(0.0, 1.0, 0.0).m_82546_(player.m_20182_()).m_82541_().m_82490_(0.75));
                    player.f_19789_ = 0.0f;
                    player.f_19794_ = true;
                    player.m_20095_();
                } else {
                    positions.remove(positions.size() - 1);
                    NBTUtils.setList(stack, TAG_POSITION, positions);
                }
            } else {
                NBTUtils.setInt(stack, TAG_TIME, 0);
            }
        }
        if (player.f_19797_ % 20 == 0) {
            if ((double)positions.size() >= 5.0 * this.getAbilityValue(stack, "seal", TAG_TIME)) {
                positions.remove(0);
            }
            if (positions.isEmpty() || player.m_20182_().m_82554_(NBTUtils.parsePosition(positions.get(positions.size() - 1))) >= 2.0) {
                if (worldIn.m_46472_().m_135782_().toString().equals(NBTUtils.getString(stack, TAG_WORLD, ""))) {
                    positions.add(NBTUtils.writePosition(player.m_20182_()));
                } else {
                    positions.clear();
                    NBTUtils.setString(stack, TAG_WORLD, worldIn.m_46472_().m_135782_().toString());
                }
            }
            NBTUtils.setList(stack, TAG_POSITION, positions);
        }
    }

    public int getMaxDamage(ItemStack stack) {
        return 1;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public boolean m_5812_(ItemStack stack) {
        return NBTUtils.getInt(stack, TAG_TIME, 0) > 0;
    }

    @Override
    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return false;
    }

    @Mod.EventBusSubscriber
    public static class Events {
        @SubscribeEvent
        public static void onLivingAttack(LivingAttackEvent event) {
            LivingEntity entity = event.getEntity();
            if (!(entity instanceof Player)) {
                return;
            }
            Player player = (Player)entity;
            for (int slot2 : EntityUtils.getSlotsWithItem(player, (Item)ItemRegistry.SPATIAL_SIGN.get()).stream().filter(slot -> slot != -1).toList()) {
                ItemStack stack = player.m_150109_().m_8020_(slot2);
                if (!(stack.m_41720_() instanceof SpatialSignItem) || NBTUtils.getInt(stack, SpatialSignItem.TAG_TIME, 0) <= 0) continue;
                event.setCanceled(true);
                return;
            }
        }
    }
}

