/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.necklace;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.hurts.sskirillss.relics.client.models.items.CurioModel;
import it.hurts.sskirillss.relics.init.EffectRegistry;
import it.hurts.sskirillss.relics.items.relics.base.IRenderableCurio;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.CastData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class JellyfishNecklaceItem
extends RelicItem
implements IRenderableCurio {
    @Override
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder("unsinkable").maxLevel(0).build()).ability(AbilityData.builder("shock").active(CastData.builder().type(CastType.TOGGLEABLE).build()).stat(StatData.builder("damage").initialValue(0.5, 2.5).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.2).formatValue(value -> MathUtils.round(value, 1)).build()).build()).ability(AbilityData.builder("paralysis").requiredLevel(5).stat(StatData.builder("duration").initialValue(0.5, 1.5).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> MathUtils.round(value, 1)).build()).build()).build()).leveling(new LevelingData(100, 10, 200)).loot(LootData.builder().entry(LootCollections.AQUATIC).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.m_204029_(FluidTags.f_13131_)) {
            EntityUtils.applyAttribute((LivingEntity)player, stack, (Attribute)ForgeMod.ENTITY_GRAVITY.get(), -1.0f, AttributeModifier.Operation.MULTIPLY_TOTAL);
        } else {
            EntityUtils.removeAttribute((LivingEntity)player, stack, (Attribute)ForgeMod.ENTITY_GRAVITY.get(), AttributeModifier.Operation.MULTIPLY_TOTAL);
        }
        Level level = player.m_20193_();
        if (!player.m_5833_() && this.isAbilityTicking(stack, "shock")) {
            for (LivingEntity entity : level.m_45976_(LivingEntity.class, player.m_20191_())) {
                if (entity == player || !EntityUtils.hurt(entity, level.m_269111_().m_269075_(player), (float)this.getAbilityValue(stack, "shock", "damage"))) continue;
                this.spreadExperience((LivingEntity)player, stack, 1);
                if (!this.canUseAbility(stack, "paralysis")) continue;
                entity.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.PARALYSIS.get(), (int)Math.round(this.getAbilityValue(stack, "paralysis", "duration") * 20.0), 0));
            }
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        EntityUtils.removeAttribute(slotContext.entity(), stack, (Attribute)ForgeMod.ENTITY_GRAVITY.get(), AttributeModifier.Operation.MULTIPLY_TOTAL);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        CurioModel model = this.getModel(stack);
        matrixStack.m_85836_();
        LivingEntity entity = slotContext.entity();
        model.m_6839_(entity, limbSwing, limbSwingAmount, partialTicks);
        model.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        ICurioRenderer.translateIfSneaking((PoseStack)matrixStack, (LivingEntity)entity);
        ICurioRenderer.rotateIfSneaking((PoseStack)matrixStack, (LivingEntity)entity);
        ICurioRenderer.followBodyRotations((LivingEntity)entity, (HumanoidModel[])new HumanoidModel[]{model});
        VertexConsumer vertexconsumer = ItemRenderer.m_115184_((MultiBufferSource)renderTypeBuffer, (RenderType)RenderType.m_110431_((ResourceLocation)this.getTexture(stack)), (boolean)false, (boolean)stack.m_41790_());
        matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
        model.m_7695_(matrixStack, vertexconsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.m_85841_(2.0f, 2.0f, 2.0f);
        matrixStack.m_85849_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public LayerDefinition constructLayerDefinition() {
        MeshDefinition mesh = HumanoidModel.m_170681_((CubeDeformation)new CubeDeformation(0.4f), (float)0.0f);
        PartDefinition bone = mesh.m_171576_().m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-8.0f, 0.0f, -4.15f, 16.0f, 7.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        bone.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(10, 16).m_171488_(-0.675f, 0.575f, -0.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.9708f, (float)8.2331f, (float)-4.6f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        bone.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(10, 16).m_171488_(0.0f, -2.5f, -0.475f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.9708f, (float)8.2331f, (float)-4.6f, (float)0.0f, (float)0.0f, (float)1.5708f));
        bone.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(10, 16).m_171488_(1.5f, -2.25f, -0.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.9708f, (float)8.2331f, (float)-4.6f, (float)0.0f, (float)0.0f, (float)0.7854f));
        bone.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(10, 16).m_171488_(-1.0104f, 0.5429f, -0.55f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.225f)), PartPose.m_171423_((float)0.0354f, (float)7.1821f, (float)-4.575f, (float)0.0f, (float)0.0f, (float)-0.004f));
        bone.m_171599_("cube_r5", CubeListBuilder.m_171558_().m_171514_(1, 16).m_171488_(-1.5104f, -2.4571f, -1.05f, 3.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0354f, (float)7.6821f, (float)-4.575f, (float)0.0f, (float)0.0f, (float)-0.004f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)64);
    }

    @Override
    public List<String> headParts() {
        return Lists.newArrayList((Object[])new String[]{"body"});
    }
}

