/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.util;

import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.Validate;

public class RegistryHelper {
    private RegistryHelper() {
    }

    public static ResourceLocation getItemKey(Item item) {
        ResourceLocation itemKey = ForgeRegistries.ITEMS.getKey((Object)item);
        Validate.notNull((Object)itemKey, (String)"itemKey", (Object[])new Object[0]);
        return itemKey;
    }

    public static <V> Optional<ResourceLocation> getRegistryName(IForgeRegistry<V> registry, V registryEntry) {
        return Optional.ofNullable(registry.getKey(registryEntry));
    }

    public static Optional<Item> getItemFromName(String itemName) {
        ResourceLocation key = new ResourceLocation(itemName);
        if (ForgeRegistries.ITEMS.containsKey(key)) {
            return Optional.of((Item)ForgeRegistries.ITEMS.getValue(key));
        }
        return Optional.empty();
    }

    public static Optional<ResourceLocation> getBlockKey(Block block) {
        return Optional.ofNullable(ForgeRegistries.BLOCKS.getKey((Object)block));
    }
}

