/*
 * Decompiled with CFR 0.152.
 */
package com.edge.trpg.world;

import com.edge.trpg.blocks.ModBlocks;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraftforge.common.util.ITeleporter;

public class MiningWorldTeleporter
implements ITeleporter {
    private final BlockPos pos;

    public MiningWorldTeleporter(BlockPos pos) {
        this.pos = pos;
    }

    public Entity placeEntity(Entity entity, ServerLevel currentWorld, ServerLevel destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
        Entity e = repositionEntity.apply(false);
        if (!(e instanceof ServerPlayer)) {
            return e;
        }
        ServerPlayer player = (ServerPlayer)e;
        destWorld.m_46865_(this.pos);
        BlockPos portalBlockPos = this.findDestinationPortal(destWorld.m_46865_(this.pos));
        BlockPos targetPos = portalBlockPos != null ? this.getSafeTopPosition((Level)destWorld, portalBlockPos.m_7494_()) : this.getSafeTopPosition((Level)destWorld, this.pos);
        player.m_6021_((double)targetPos.m_123341_() + 0.5, (double)targetPos.m_123342_(), (double)targetPos.m_123343_() + 0.5);
        return e;
    }

    private BlockPos findDestinationPortal(ChunkAccess chunk) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 255; y >= 1; --y) {
                    pos.m_122178_(x, y, z);
                    if (!chunk.m_8055_((BlockPos)pos).m_60713_((Block)ModBlocks.MINING_PORTAL.get())) continue;
                    return chunk.m_7697_().m_45615_().m_7918_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                }
            }
        }
        return null;
    }

    private BlockPos getSafeTopPosition(Level world, BlockPos basePos) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int y = basePos.m_123342_(); y >= world.m_141937_() + 2; --y) {
            boolean spaceAbove;
            pos.m_122178_(basePos.m_123341_(), y, basePos.m_123343_());
            BlockState ground = world.m_8055_((BlockPos)pos);
            BlockState above = world.m_8055_(pos.m_7494_());
            BlockState above2 = world.m_8055_(pos.m_6630_(2));
            boolean validGround = ground.m_60713_(Blocks.f_50069_) || ground.m_60713_(Blocks.f_50493_) || ground.m_60713_(Blocks.f_50440_);
            boolean bl = spaceAbove = above.m_60795_() && above2.m_60795_();
            if (!validGround || !spaceAbove) continue;
            return pos.m_7494_().m_7949_();
        }
        return basePos;
    }
}

