/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.twilightforestfinalboss.configuration;

import net.minecraftforge.common.ForgeConfigSpec;

public class TwilightForestFinalBossConfigConfiguration {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.ConfigValue<Boolean> SHOULD_SHOOT_GHAST_FIREBALLS;
    public static final ForgeConfigSpec.ConfigValue<Boolean> SHOULD_SHOOT_BLAZE_FIREBALLS;
    public static final ForgeConfigSpec.ConfigValue<Boolean> SHOULD_SHOOT_DRAGON_FIREBALLS;
    public static final ForgeConfigSpec.ConfigValue<Boolean> SHOULD_SHOOT_WITHER_SKULLS;
    public static final ForgeConfigSpec.ConfigValue<Double> CUBE_OF_ANNIHILATION_RANGE;
    public static final ForgeConfigSpec.ConfigValue<Double> CUBE_OF_ANNIHILATION_DAMAGE;
    public static final ForgeConfigSpec.ConfigValue<Double> STOMP_ATTACK_RANGE;
    public static final ForgeConfigSpec.ConfigValue<Double> STOMP_ATTACK_DAMAGE;
    public static final ForgeConfigSpec.ConfigValue<Double> STOMP_ATTACK_Y_LAUNCH;
    public static final ForgeConfigSpec.ConfigValue<Double> STOMP_ATTACK_XZ_LAUNCH;
    public static final ForgeConfigSpec.ConfigValue<Double> LOBBED_FIREBALL_XZ_RANGE;
    public static final ForgeConfigSpec.ConfigValue<Double> LOBBED_FIREBALL_Y_RANGE;
    public static final ForgeConfigSpec.ConfigValue<Boolean> SUMMON_MAIN_BOSSES;
    public static final ForgeConfigSpec.ConfigValue<Boolean> SUMMON_MINI_BOSSES;
    public static final ForgeConfigSpec.ConfigValue<Boolean> SUMMON_HARBINGER_CUBES;
    public static final ForgeConfigSpec.ConfigValue<Double> HARBINGER_CUBE_SPAWN_CHANCE;
    public static final ForgeConfigSpec.ConfigValue<Boolean> SUMMON_ADHERENTS;
    public static final ForgeConfigSpec.ConfigValue<Double> ADHERENT_SPAWN_CHANCE;

    static {
        BUILDER.push("Final Boss Attacks");
        BUILDER.push("Arm cannon projectile (multiple of these can be set to true at once)");
        SHOULD_SHOOT_GHAST_FIREBALLS = BUILDER.comment("Makes arm cannon attack shoot ghast fireballs").define("Should Shoot Ghast Fireballs", true);
        SHOULD_SHOOT_BLAZE_FIREBALLS = BUILDER.comment("Makes arm cannon attack shoot blaze fireballs").define("Should Shoot Blaze Fireballs", false);
        SHOULD_SHOOT_DRAGON_FIREBALLS = BUILDER.comment("Makes arm cannon attack shoot dragon fireballs").define("Should Shoot Dragon Fireballs", false);
        SHOULD_SHOOT_WITHER_SKULLS = BUILDER.comment("Makes arm cannon attack shoot wither skulls").define("Should Shoot Wither Skulls", false);
        BUILDER.pop();
        BUILDER.push("Cube of Annihilation attack");
        CUBE_OF_ANNIHILATION_RANGE = BUILDER.comment("Sets the range that the cube of annihilation can hit entities from (this can be a negative value)").define("Cube Of Annihilation Range", (Object)5.0);
        CUBE_OF_ANNIHILATION_DAMAGE = BUILDER.comment("Sets the damage that the cube of annihilation attack does").define("Cube Of Annihilation Damage", (Object)4.0);
        BUILDER.pop();
        BUILDER.push("Stomp attack");
        STOMP_ATTACK_RANGE = BUILDER.comment("Sets the range (in cubic blocks) for the stomp attack to hit entities").define("Stomp Attack Range", (Object)10.0);
        STOMP_ATTACK_DAMAGE = BUILDER.comment("Sets the damage that the stomp attack does").define("Stomp Attack Damage", (Object)10.0);
        STOMP_ATTACK_Y_LAUNCH = BUILDER.comment("Sets the y vector that the stomp attack applies to hit entities").define("Stomp Attack Y Launch", (Object)2.5);
        STOMP_ATTACK_XZ_LAUNCH = BUILDER.comment("Sets the x and z vectors that the stomp attack applies to hit entities").define("Stomp Attack XZ Launch", (Object)2.0);
        BUILDER.pop();
        BUILDER.push("Lobbed fireballs attack");
        LOBBED_FIREBALL_XZ_RANGE = BUILDER.comment("Sets the max x and z spread for the lobbed fireballs").define("Lobbed Fireball XZ Range", (Object)1.0);
        LOBBED_FIREBALL_Y_RANGE = BUILDER.comment("Sets the y shoot distance for the lobbed fireballs").define("Lobbed Fireball Y Range", (Object)2.0);
        BUILDER.pop();
        BUILDER.pop();
        BUILDER.push("Final Boss Special Abilities");
        SUMMON_MAIN_BOSSES = BUILDER.comment("Makes the Castle Keeper summon the main Twilight Forest bosses").define("Summon Main Bosses", true);
        SUMMON_MINI_BOSSES = BUILDER.comment("Makes the Castle Keeper summon the mini bosses from Twilight Forest bosses").define("Summon Mini Bosses", false);
        SUMMON_HARBINGER_CUBES = BUILDER.comment("Makes the Castle Keeper summon harbinger cubes randomly when hit").define("Summon Harbinger Cubes", true);
        HARBINGER_CUBE_SPAWN_CHANCE = BUILDER.comment("Sets the chance for a harbinger cube to be summoned when the castle keeper is hit (0-1)").define("Harbinger Cube Spawn Chance", (Object)0.3);
        SUMMON_ADHERENTS = BUILDER.comment("Makes the Castle Keeper summon adherents randomly when hit").define("Summon Adherents", true);
        ADHERENT_SPAWN_CHANCE = BUILDER.comment("Sets the chance for an adherent to be summoned when the Castle Keeper is hit (0-1)").define("Adherent Spawn Chance", (Object)0.3);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

